/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorityBinding;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLDoNotCacheCondition;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;

public class TokenValidatorTest
extends TestCase {
    public OMElement loadFromFile(String filename) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(filename);
        return builder.getDocumentElement();
    }

    public OMElement generateSignedSAML() {
        try {
            SAMLAssertion s = new SAMLAssertion();
            s.setId("test-assertion1");
            s.setIssuer("http://www.acmesoftware.com/sts");
            s.setMinorVersion(1);
            s.setIssueInstant(new SimpleDateFormat("MM/dd/yyyy hh:mm").parse("12/09/2005 11:05"));
            s.setNotBefore(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse("12/09/2006 11:11:11"));
            s.setNotOnOrAfter(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse("12/09/2007 12:12:12"));
            SAMLDoNotCacheCondition c1 = new SAMLDoNotCacheCondition();
            s.addCondition((SAMLCondition)c1);
            SAMLAudienceRestrictionCondition c2 = new SAMLAudienceRestrictionCondition();
            c2.addAudience("www.serena.com");
            c2.addAudience("www.merant.com");
            s.addCondition((SAMLCondition)c2);
            s.addAdvice((Object)"advice1");
            s.addAdvice((Object)"advice2");
            SAMLNameIdentifier ni = new SAMLNameIdentifier();
            ni.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            ni.setNameQualifier("http://www.serena.com");
            ni.setName("bbunny@acme.com");
            SAMLAuthenticationStatement auth = new SAMLAuthenticationStatement();
            auth.setAuthMethod("urn:oasis:names:tc:SAML:1.0:am:password");
            auth.setAuthInstant(new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse("09/09/2005 09:05:11"));
            auth.setSubjectIP("192.168.2.1");
            auth.setSubjectDNS("dns");
            SAMLSubject subj = new SAMLSubject();
            subj.setNameIdentifier(ni);
            subj.addConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
            auth.setSubject(subj);
            auth.setAuthInstant(new SimpleDateFormat("MM/dd/yyyy HH:mm").parse("09/09/2005 09:05:11"));
            SAMLAuthorityBinding authBinding = new SAMLAuthorityBinding();
            authBinding.setAuthorityKind(new QName("t1:t2", "t2"));
            authBinding.setBinding("todo: bidning");
            authBinding.setLocation("authority location");
            auth.addBinding(authBinding);
            s.addStatement((SAMLStatement)auth);
            SAMLAttributeStatement attrStmt = new SAMLAttributeStatement();
            SAMLAttribute attr1 = new SAMLAttribute();
            attr1.setName("Attribute1");
            attr1.setLifetime(1000L);
            attr1.setNamespace("urn:alf:names:ssotgt:1.0:attr:attr1_format");
            attr1.addValue((Object)"attr1_value");
            attrStmt.setSubject((SAMLSubject)subj.clone());
            attrStmt.addAttribute(attr1);
            s.addStatement((SAMLStatement)attrStmt);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("test-resources/sec/keystore.jks"), "password".toCharArray());
            Key key = ks.getKey("ca", "password".toCharArray());
            s.sign("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1", key, null);
            String str = s.toString();
            OMElement el = XMLHelper.toOM((String)str);
            return null;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error creating SAML", e);
        }
    }

    public void testValidateToken() {
        try {
            OMElement elem = this.loadFromFile("test-resources/saml/saml10_2.xml");
            elem = this.generateSignedSAML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TokenValidatorTest t = new TokenValidatorTest();
        t.testValidateToken();
    }
}

