/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;

public class WSFUtilsTest
extends TestCase {
    public String getParams(String paramUrl) {
        WSFUtilsTest.assertNotNull((Object)paramUrl);
        Pattern p = Pattern.compile("");
        return null;
    }

    public void testGenerateRedirectURL() {
        URL url;
        WSFedData wsfData = WSFedDataObjectFactory.createWSFedData();
        wsfData.setWa("wsignin1.0");
        wsfData.setWreq("REQEST_SECURITY_TOKEN");
        wsfData.setWctx("CONTEXT");
        String redirectUrl = "https://redirect.com/STS";
        String urlStr = WSFedHelper.generateRedirectURL((String)redirectUrl, (WSFedData)wsfData);
        WSFUtilsTest.assertNotNull((Object)urlStr);
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new AssertionFailedError();
        }
        WSFUtilsTest.assertNotNull((Object)url);
        Hashtable params = WSFedHelper.getParamsFromURL((String)url.toString());
        WSFUtilsTest.assertNotNull((Object)params);
        WSFUtilsTest.assertNotNull(params.get("wa"));
        WSFUtilsTest.assertEquals(params.get("wa"), (Object)"wsignin1.0");
        WSFUtilsTest.assertNotNull(params.get("wreq"));
        WSFUtilsTest.assertEquals(params.get("wreq"), (Object)"REQEST_SECURITY_TOKEN");
        WSFUtilsTest.assertNotNull(params.get("wctx"));
        WSFUtilsTest.assertEquals(params.get("wctx"), (Object)"CONTEXT");
    }
}

