/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.GatekeeperRequestDispatcher;
import org.eclipse.alf.security.sso.server.gatekeeper.PostAuthServletRequest;
import org.eclipse.alf.security.sso.server.gatekeeper.PredispatchServletRequest;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.builder.GatekeeperConfigBuilder;

public class GatekeeperFilter
implements Filter {
    private static final Logger log = Logger.getLogger(GatekeeperFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        File f;
        String newssoConfigDir;
        File d;
        String filterBasePath = FileIOHelper.normalizePath((String)(filterConfig.getServletContext().getRealPath("") + "/"));
        if (StringHelper.isBlank((String)filterBasePath)) {
            log.warn((Object)"FilterConfig.getServletContext().getRealPath() failed to return the real path. Trying filter init parameters");
            filterBasePath = filterConfig.getInitParameter("GATEKEEEPER_ROOT_PATH");
            if (StringHelper.isBlank((String)filterBasePath)) {
                log.debug((Object)"Filter init parameter \"ROOT_PATH\" not defined. Trying context init parameters");
                filterBasePath = filterConfig.getServletContext().getInitParameter("ROOT_PATH");
            }
        }
        if (StringHelper.isBlank((String)filterBasePath)) {
            log.error((Object)"Failed to resolve root real path - neither the servlet container returned it or the context params have it");
            throw new ServletException("Failed to resolve root real path");
        }
        File filterBasePathFile = new File(filterBasePath);
        if (!filterBasePathFile.isDirectory()) {
            log.error((Object)("Filter root real path: \"" + filterBasePath + "\" does not exist"));
            throw new ServletException("Failed to resolve root path");
        }
        log.debug((Object)("Gatekeeper filter: using filter base path: \"" + filterBasePath + "\""));
        String ssoConfigDir = System.getProperty("org.eclipse.alf.security.sso.server.gatekeeper.conf-dir");
        if (StringHelper.isBlank((String)ssoConfigDir)) {
            ssoConfigDir = filterConfig.getInitParameter("GatekeeperConfigDir");
        }
        if (StringHelper.isBlank((String)ssoConfigDir)) {
            ssoConfigDir = filterBasePath;
        }
        if (!(d = new File(ssoConfigDir)).isDirectory() && !(d = new File(newssoConfigDir = FileIOHelper.normalizePath((String)(filterBasePath + "/" + ssoConfigDir)))).isDirectory()) {
            String errorMessage = "Failed to load configuration settings. Tried both \"" + ssoConfigDir + "\" and \"" + newssoConfigDir + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        ssoConfigDir = FileIOHelper.normalizePath((String)(d.getAbsolutePath() + "/"));
        log.debug((Object)("Gatekeeper using configuration base path: \"" + ssoConfigDir + "\""));
        String ssoConfigName = System.getProperty("org.eclipse.alf.security.sso.server.gatekeeper.conf-name");
        if (StringHelper.isBlank((String)ssoConfigName)) {
            ssoConfigName = filterConfig.getInitParameter("GatekeeperConfigFile");
        }
        if (StringHelper.isBlank((String)ssoConfigName)) {
            ssoConfigName = "gatekeeper-services-config.xml";
        }
        if ((f = new File(FileIOHelper.normalizePath((String)ssoConfigName))).isFile()) {
            ssoConfigDir = FileIOHelper.normalizePath((String)(f.getParent() + "/"));
            ssoConfigName = f.getName();
        } else {
            f = new File(FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName)));
            if (f.isFile()) {
                ssoConfigDir = FileIOHelper.normalizePath((String)(f.getParent() + "/"));
                ssoConfigName = f.getName();
            } else {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Failed to find configuration in \"" + fullpath + "\"";
                log.fatal((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
        }
        GatekeeperConfigBuilder configBuilder = new GatekeeperConfigBuilder(ssoConfigDir);
        GatekeeperConfig config = null;
        try {
            config = configBuilder.build(ssoConfigName);
        }
        catch (Exception e) {
            String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
            String errorMessage = "Failed to load configuration from \"" + fullpath + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage, (Throwable)e);
        }
        if (config == null) {
            String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
            String errorMessage = "Failed to load configuration from \"" + fullpath + "\"";
            log.fatal((Object)errorMessage);
            throw new ServletException(errorMessage);
        }
        Iterator it = config.getServiceConfigIterator();
        if (it != null) {
            while (it.hasNext()) {
                GatekeeperServiceConfig serviceConfig = (GatekeeperServiceConfig)it.next();
                serviceConfig.getCoreConfig().setProperty("ApplicationRootAbsolutePath", filterBasePath);
                serviceConfig.getCoreConfig().setProperty("ConfigBaseAbsolutePath", ssoConfigDir);
                serviceConfig.getCoreConfig().registerSubstitutionVariable("${APPROOT_DIR}", filterBasePath);
                serviceConfig.getCoreConfig().registerSubstitutionVariable("${CONFIG_DIR}", ssoConfigDir);
                serviceConfig.getCoreConfig().expandSubstitutionVariables();
            }
        }
        GatekeeperConfig.setInstance(config);
    }

    public void destroy() {
        log.debug((Object)"Destroying gakekeeper");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String newLine = System.getProperty("line.separator");
        Object req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (SOAPHelper.isSOAPRequestProfile((HttpServletRequest)req)) {
            if (!req.getInputStream().markSupported()) {
                req = new PredispatchServletRequest((HttpServletRequest)req);
            }
            req.getInputStream().mark(Integer.MAX_VALUE);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  Entering doFilter  =========="));
        }
        ALFSSOPrincipal principal = GatekeeperRequestDispatcher.dispatchRequest(req, resp);
        req.getInputStream().reset();
        if (principal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication failed for HTTP request");
            }
            return;
        }
        if (principal.getSSOToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Letting request through with NO princial object");
            }
            principal = null;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Request successfully authenticated principal \"" + principal.getName() + "\""));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  In doFilter before chain.doFilter  =========="));
        }
        chain.doFilter((ServletRequest)new PostAuthServletRequest((HttpServletRequest)req, (Principal)principal), response);
        if (log.isDebugEnabled()) {
            log.debug((Object)(newLine + "==========  Leaving doFilter. After chain.doFilter  =========="));
        }
    }

    public void setFilterConfig(FilterConfig f) {
        try {
            this.init(f);
        }
        catch (Exception e) {
            log.error((Object)"Unable to initialize FilterConfig", (Throwable)e);
            e.printStackTrace();
        }
    }

    public FilterConfig getFilterConfig() {
        return null;
    }
}

