/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.HTMLMessageFactory;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.FederationServicesResponseHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPSignOutRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.RemoteDataRequestHandler;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.SOAPRequestHandler;

public class GatekeeperRequestDispatcher {
    static final Logger log = Logger.getLogger(GatekeeperRequestDispatcher.class);

    public static ALFSSOPrincipal dispatchRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        GatekeeperConfig gatekeeperConfig = GatekeeperConfig.getInstance();
        GatekeeperServiceConfig serviceConfig = gatekeeperConfig.getServiceConfigByURI(req.getRequestURI(), req.getParameterMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering dispatchRequest");
        }
        ALFSSOPrincipal principal = null;
        if (!gatekeeperConfig.isProtectedURI(req.getRequestURI(), req.getParameterMap())) {
            return new ALFSSOPrincipal(null);
        }
        RemoteDataRequestHandler remoteDataRequestHandler = new RemoteDataRequestHandler();
        if (remoteDataRequestHandler.isValidRemoteDataRequest(req)) {
            remoteDataRequestHandler.serveRequest(req, resp);
            return null;
        }
        if (serviceConfig == null) {
            log.error((Object)("Error configuration for URL \"" + req.getRequestURL() + "\" cannot be resolved"));
            HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Error configuration for URL \"" + req.getRequestURL() + "\" cannot be resolved", null);
            return null;
        }
        if (serviceConfig.getType() == 0) {
            log.info((Object)("Service \"" + serviceConfig.getName() + "\" rejected request: not configured to handle requests"));
            return null;
        }
        boolean browserRequestsEnabled = serviceConfig.getProtectionLevel() == 2 || serviceConfig.getProtectionLevel() == 1;
        boolean soapRequestsEnabled = serviceConfig.getProtectionLevel() == 2 || serviceConfig.getProtectionLevel() == 0;
        WSFedData wsfData = null;
        if (browserRequestsEnabled) {
            wsfData = FederationServicesResponseHelper.extractWSFedDataFromRequest(req, resp);
            if (wsfData != null) {
                ExtendedResult validationResult = FederationServicesResponseHelper.validateWSFedResponseProfile(wsfData);
                if (!validationResult.isSuccess()) {
                    HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Invalid login parameters", validationResult.getMessage());
                    return null;
                }
                boolean wsfDataIsRemoted = false;
                try {
                    wsfDataIsRemoted = FederationServicesResponseHelper.isWSFedResponseDataRemoted(wsfData);
                }
                catch (SSOException e) {
                    HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Error in federated services login parameters", e.getMessage());
                    return null;
                }
                if (wsfDataIsRemoted) {
                    try {
                        wsfData = FederationServicesResponseHelper.extractWSFedRemotedData(req, resp, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)"Error extracting remoted data", (Throwable)e);
                        HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Error in federated services login sequence", e.getMessage());
                        return null;
                    }
                }
            }
            if (wsfData != null) {
                if (wsfData.isSigninAction()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing a sign-in response from WS-Federation services");
                    }
                    try {
                        principal = HTTPRequestHandler.processHTTPRequest(req, resp, serviceConfig, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)("Error authenticating: " + e.getMessage()), (Throwable)e);
                        HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Authentication processing error", e.getMessage());
                        return null;
                    }
                    return principal;
                }
                if (wsfData.isSignoutAction()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Processing a sign-out response from WS-Federation services");
                    }
                    try {
                        principal = HTTPSignOutRequestHandler.processSignout(req, resp, serviceConfig, wsfData);
                    }
                    catch (SSOException e) {
                        log.error((Object)"Error authenticating", (Throwable)e);
                        HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Signout processing error", e.getMessage());
                        return null;
                    }
                    return principal;
                }
                if (wsfData.isSignoutCleanupAction()) {
                    // empty if block
                }
            }
        }
        if (soapRequestsEnabled && SOAPHelper.isSOAPRequestProfile((HttpServletRequest)req)) {
            SOAPEnvelope soapEnvelope = null;
            try {
                soapEnvelope = SOAPHelper.buildSOAPEnvelope((InputStream)req.getInputStream());
            }
            catch (IOException e) {
                log.error((Object)"Error in authentication", (Throwable)e);
                HTMLMessageFactory.setApplicationErrorResponse(req, resp, "SOAP processing error", e.getMessage());
                return null;
            }
            if (soapEnvelope != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing a SOAP request");
                }
                SOAPRequestHandler soapHandler = new SOAPRequestHandler();
                try {
                    principal = soapHandler.processSOAPMessage(req, resp, serviceConfig, soapEnvelope);
                }
                catch (SSOException e) {
                    log.error((Object)"Error in authentication", (Throwable)e);
                    HTMLMessageFactory.setApplicationErrorResponse(req, resp, "SOAP processing error", e.getMessage());
                    return null;
                }
                return principal;
            }
        }
        if (browserRequestsEnabled) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing a Non-SOAP HTTP request");
                }
                principal = HTTPRequestHandler.processHTTPRequest(req, resp, serviceConfig, null);
            }
            catch (SSOException e) {
                log.error((Object)"Error in authentication", (Throwable)e);
                HTMLMessageFactory.setApplicationErrorResponse(req, resp, "Authentication processing error", e.getMessage());
                return null;
            }
            return principal;
        }
        return null;
    }
}

