/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;

public class HTMLMessageFactory {
    static final Logger log = Logger.getLogger(HTMLMessageFactory.class);

    public static void setApplicationErrorResponse(HttpServletRequest req, HttpServletResponse resp, String errorMessage, String detailedErrorMessage) throws ServletException {
        log.info((Object)("Redirecting to application error page. error=\"" + errorMessage + "\""));
        GatekeeperServiceConfig conf = GatekeeperConfig.getInstance().getServiceConfigByURI(req.getRequestURI(), req.getParameterMap());
        String redirectPage = null;
        redirectPage = conf != null ? conf.getCoreConfig().getParameter("ApplicationErrorPage", "") : "";
        if (StringHelper.isBlank((String)redirectPage)) {
            PrintWriter writer = null;
            try {
                writer = resp.getWriter();
            }
            catch (IOException e) {
                log.error((Object)"Cannot get response writer", (Throwable)e);
                throw new ServletException("Cannot get response writer", (Throwable)e);
            }
            String errorMessageHTMLLine = StringHelper.isBlank((String)detailedErrorMessage) ? "<H2>Unknown ALF SSO Gatekeeper error</H2>" : "<H2>ALF SSO Gatekeeper error has occured: " + errorMessage + "</H2>";
            String detailErrorMessageHTMLLine = StringHelper.isBlank((String)detailedErrorMessage) ? "" : "<p><b>Detail</b></p><p> " + detailedErrorMessage + "</p>";
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>Error Page</title>");
            writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            writer.println("</head>");
            writer.println("<body bgcolor=\"#FFFFFF\">");
            writer.println(errorMessageHTMLLine);
            writer.println(detailErrorMessageHTMLLine);
            writer.println("</body>");
            writer.println("</html>");
        } else {
            req.setAttribute("errorMessage", (Object)errorMessage);
            req.setAttribute("detailedErrorMessage", (Object)detailedErrorMessage);
            RequestDispatcher rd = req.getRequestDispatcher(redirectPage);
            try {
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            }
            catch (IOException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
        }
    }

    public static void setApplicationErrorOutput(HttpServletRequest req, HttpServletResponse resp, String msg, Exception ex) throws ServletException {
        PrintWriter writer = null;
        try {
            writer = resp.getWriter();
        }
        catch (IOException e) {
            log.error((Object)"Cannot get response writer", (Throwable)e);
            throw new ServletException("Cannot get response writer", (Throwable)e);
        }
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>Error Page</title>");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        writer.println("</head>");
        writer.println("<body bgcolor=\"#FFFFFF\">");
        writer.println("<P><A href=\" + resp.encodeURL(request.getContextPath()) \">Home</A></P>");
        writer.println("<hr>");
        writer.println("<H2>An Application error has occured:</H2>");
        writer.println("<TABLE CELLPADDING=\"2\" CELLSPACING=\"2\" BORDER=\"1\" WIDTH=\"100%\">");
        writer.println("<TR>");
        writer.println("<TD WIDTH=\"20%\"><B>Message</B></TD>");
        writer.println("<TD WIDTH=\"80%\">" + msg + "</TD>");
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD WIDTH=\"20%\"><B>Exception Type</B></TD>");
        writer.println("<TD WIDTH=\"80%\">" + ex.getClass().getName() + "</TD>");
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD WIDTH=\"20%\"><B>Exception Message</B></TD>");
        writer.println("<TD WIDTH=\"80%\">" + ex.getMessage() + "</TD>");
        writer.println("</TR>");
        writer.println("<TR>");
        writer.println("<TD WIDTH=\"20%\"><B>Exception Stack Trace</B></TD>");
        writer.println("<TD WIDTH=\"80%\">");
        if (ex != null) {
            writer.print("<PRE>");
            ex.printStackTrace(writer);
            writer.print("</PRE>");
        }
        writer.println("</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        writer.println("<hr>");
        writer.println("Header List");
        writer.println("<table border=3>");
        writer.println("<tr>");
        writer.println("<td>Name</td>");
        writer.println("<td>Value</td>");
        writer.println("</tr>");
        String name = "";
        String value = "";
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            name = (String)headers.nextElement();
            value = req.getHeader(name);
        }
        writer.println("<tr>");
        writer.println("<td>" + name + "</td>");
        writer.println("<td>" + value + "</td>");
        writer.println("</tr>");
        writer.println("</table>");
        writer.println("Attribute List");
        writer.println("<table border=3>");
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            name = (String)attributes.nextElement();
            value = req.getAttribute(name) == null ? "null" : req.getAttribute(name).toString();
            writer.println("<tr>");
            writer.println("<td>" + name + "</td>");
            writer.println("<td>" + value + "</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
        writer.println("</body>");
        writer.println("</html>");
    }
}

