/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.common.token.SSOToken;

public class PostAuthServletRequest
extends HttpServletRequestWrapper {
    static final Logger log = Logger.getLogger(PostAuthServletRequest.class);
    private Principal principal;

    PostAuthServletRequest(HttpServletRequest req, Principal principal) {
        super(req);
        this.principal = principal;
    }

    public String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return super.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        if (this.principal != null) {
            return this.principal;
        }
        return super.getUserPrincipal();
    }

    public String getAuthType() {
        if (this.principal != null) {
            return "ALF-SSO";
        }
        return super.getAuthType();
    }

    public String getHeader(String headerName) {
        if (headerName.equals("ALFSSOAuthNToken") && this.principal != null && this.principal instanceof ALFSSOPrincipal) {
            SSOToken token = ((ALFSSOPrincipal)this.principal).getSSOToken();
            return token.toString();
        }
        return super.getHeader(headerName);
    }

    public Enumeration getHeaderNames() {
        Enumeration headerNames = super.getHeaderNames();
        Vector v = new Vector();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                v.add(headerNames.nextElement());
            }
            if (this.principal != null) {
                v.add("ALFSSOAuthNToken");
            }
        }
        return v.elements();
    }
}

