/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.RewindableServletInputStream;
import org.opensaml.artifact.InvalidArgumentException;

public class PredispatchServletRequest
extends HttpServletRequestWrapper {
    static final Logger log = Logger.getLogger(PredispatchServletRequest.class);
    private RewindableServletInputStream inputStream = null;
    protected BufferedReader reader = null;
    private boolean usingReader = false;
    private boolean usingInputStream = false;
    private Map parameterMap = null;

    public PredispatchServletRequest(HttpServletRequest req) throws IOException {
        super(req);
        this.parameterMap = req.getParameterMap();
        this.inputStream = new RewindableServletInputStream((InputStream)req.getInputStream());
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException("Already using BufferedReader");
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException("Already using InputStream");
        }
        this.usingReader = true;
        if (this.reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            InputStreamReader r = new InputStreamReader((InputStream)this.inputStream, encoding);
            this.reader = new BufferedReader(r);
        }
        return this.reader;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (this.parameterMap != null) {
            Vector<String> retVal = new Vector<String>(this.parameterMap.size());
            Iterator it = this.parameterMap.keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String paramName = (String)it.next();
                    retVal.add(paramName);
                }
            }
            return retVal.elements();
        }
        return new Vector().elements();
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new InvalidArgumentException("Argument cannot be null");
        }
        if (this.parameterMap != null) {
            String[] paramValues = (String[])this.parameterMap.get(name);
            return paramValues;
        }
        return null;
    }
}

