/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.Base64;
import org.apache.rampart.handler.config.InflowConfiguration;
import org.apache.rampart.handler.config.OutflowConfiguration;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.PWCallbackStatic;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.transport.SerializingTransportSender;

public class TestSOAPLocalCallSecurity
extends TestCase {
    protected String repo = "test-resources/client_repo";
    protected String port = "8081";
    protected String erp = "http://192.168.2.18:" + this.port + "/testapp/index.jsp";
    protected ServiceClient serviceClient = null;
    protected Options options = null;
    private static final String ACTION = "After/action/satisfaction";

    public TestSOAPLocalCallSecurity() {
        super(TestSOAPLocalCallSecurity.class.getName());
    }

    public TestSOAPLocalCallSecurity(String testName) {
        super(testName);
    }

    private Options createOptions() throws Exception {
        Options o = new Options();
        o.setTo(new EndpointReference(this.erp));
        o.setTransportInProtocol("http");
        TransportOutDescription tOut = new TransportOutDescription("serialization");
        tOut.setSender((TransportSender)new SerializingTransportSender());
        o.setTransportOut(tOut);
        o.setAction(ACTION);
        o.setProperty("InflowSecurity", (Object)this.createOfc().getProperty());
        o.setProperty("OutflowSecurity", (Object)this.createOfc().getProperty());
        o.setProperty("actor", (Object)"urn:higgins:sts");
        return o;
    }

    private OutflowConfiguration createOfc() throws Exception {
        OutflowConfiguration cfg = new OutflowConfiguration();
        cfg.setActionItems("Timestamp UsernameToken");
        cfg.setUser("george");
        cfg.setPreserveOriginalEnvelope(true);
        cfg.setPasswordType("PasswordText");
        cfg.setPasswordCallbackClass(PWCallbackStatic.class.getName());
        PWCallbackStatic.setUsername((String)"george");
        PWCallbackStatic.setPassword((String)"secret");
        return cfg;
    }

    private InflowConfiguration createIfc() throws Exception {
        InflowConfiguration cfg = new InflowConfiguration();
        return cfg;
    }

    protected void setUp() throws Exception {
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repo, null);
        this.serviceClient = new ServiceClient(configContext, null);
        this.options = this.createOptions();
        this.serviceClient.engageModule(new QName("addressing"));
        this.serviceClient.engageModule(new QName("rampart"));
        this.serviceClient.setOptions(this.options);
    }

    protected void tearDown() throws Exception {
    }

    public void testSerializingSOAPMessage() throws Exception {
        OMElement payload = this.createRequestPayload();
        SOAPFactory soapFactory = null;
        String soapVersionURI = this.options.getSoapVersionURI();
        soapFactory = "http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI) ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        this.serviceClient.addStringHeader(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse"), "");
        OMElement result = this.serviceClient.sendReceive(payload);
        String decodedSOAP = SOAPHelper.extractSerializedSOAPMessage((OMElement)result);
        TestSOAPLocalCallSecurity.assertNotNull((Object)decodedSOAP);
    }

    public void testResponseInjection() throws Exception {
        OMElement payload = this.createResponsePayload();
        OMElement result = this.serviceClient.sendReceive(payload);
        String decodedResponsePayload = SOAPHelper.extractSerializedSOAPMessage((OMElement)result);
        TestSOAPLocalCallSecurity.assertNotNull((Object)decodedResponsePayload);
        String encodedPayload = Base64.encode((byte[])decodedResponsePayload.getBytes());
        this.options.setProperty("ALFSSO_RESPONSE_MESSAGE", (Object)encodedPayload);
        this.serviceClient.setOptions(this.options);
        payload = this.createDummyPayload();
        result = this.serviceClient.sendReceive(payload);
        TestSOAPLocalCallSecurity.assertEquals((Object)new QName("http://test", "response", "test"), (Object)result.getQName());
    }

    private OMElement createRequestPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement payload = fac.createOMElement("request", "http://test", "test");
        return payload;
    }

    private OMElement createResponsePayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement payload = fac.createOMElement("response", "http://test", "test");
        return payload;
    }

    private OMElement createDummyPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement payload = fac.createOMElement("dummy", "http://test", "test");
        return payload;
    }
}

