/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.URIMatcher;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.opensaml.SAMLConfig;

public class GatekeeperConfig {
    private static final Logger log = Logger.getLogger(GatekeeperConfig.class);
    public static final String DEFAULT_CONFIG_FILENAME = "gatekeeper-services-config.xml";
    public static final String PROPNAME_ROOT_PATH = "ROOT_PATH";
    public static final String PROPNAME_GATEKEEPER_ROOT_PATH = "GATEKEEEPER_ROOT_PATH";
    public static final String PROPNAME_CFG_DIR = "GatekeeperConfigDir";
    public static final String PROPNAME_CFG_NAME = "GatekeeperConfigFile";
    public static final String SYSPROP_CFG_DIR = "org.eclipse.alf.security.sso.server.gatekeeper.conf-dir";
    public static final String SYSPROP_CFG_NAME = "org.eclipse.alf.security.sso.server.gatekeeper.conf-name";
    protected HashSet protectedURIs = new HashSet();
    protected HashSet nonProtectedURIs = new HashSet();
    protected HashMap servicesByName = new HashMap();
    protected HashMap servicesByRPURI = new HashMap();

    public static synchronized GatekeeperConfig getInstance() {
        return GatekeeperConfigHolder.instance;
    }

    public static synchronized void setInstance(GatekeeperConfig newInstance) {
        GatekeeperConfigHolder.instance = newInstance;
    }

    public GatekeeperConfig() {
        this.reset();
        SAMLConfig.instance();
    }

    public void reset() {
        this.protectedURIs = new HashSet();
        this.nonProtectedURIs = new HashSet();
        this.servicesByName = new HashMap();
        this.servicesByRPURI = new HashMap();
    }

    public void addServiceConfig(GatekeeperServiceConfig serviceConfig) {
        GatekeeperServiceConfig old = (GatekeeperServiceConfig)this.servicesByName.get(serviceConfig.getName());
        if (old != null) {
            this.servicesByRPURI.remove(old.getRpuri().toString());
        }
        if ((old = (GatekeeperServiceConfig)this.servicesByRPURI.get(serviceConfig.getRpuri().toString())) != null) {
            this.servicesByName.remove(old.getName());
        }
        this.servicesByName.put(serviceConfig.getName(), serviceConfig);
        this.servicesByRPURI.put(serviceConfig.getRpuri().toString(), serviceConfig);
    }

    public GatekeeperServiceConfig getServiceConfigByName(String name) {
        if (name == null || this.servicesByName == null) {
            return null;
        }
        return (GatekeeperServiceConfig)this.servicesByName.get(name);
    }

    public GatekeeperServiceConfig getServiceConfigByURI(String uri, Map httpParamsMap) {
        if (this.servicesByName == null) {
            log.error((Object)"GetServiceConfigByURI: Service configs map not initialized");
            return null;
        }
        Iterator it = this.servicesByName.values().iterator();
        if (it == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"GetServiceConfigByURI: No service configs found");
            }
            return null;
        }
        if (!it.hasNext()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"GetServiceConfigByURI: No service configs found");
            }
            return null;
        }
        while (it.hasNext()) {
            GatekeeperServiceConfig serviceConfig = (GatekeeperServiceConfig)it.next();
            if (!serviceConfig.matchServiceURI(uri, httpParamsMap)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("GetServiceConfigByURI: Found service config match: name=\"" + serviceConfig.getName() + "\""));
            }
            return serviceConfig;
        }
        return null;
    }

    public GatekeeperServiceConfig getServiceConfigByRPURI(String rpuri) {
        if (rpuri == null || this.servicesByRPURI == null) {
            return null;
        }
        return (GatekeeperServiceConfig)this.servicesByRPURI.get(rpuri);
    }

    public Iterator getServiceConfigIterator() {
        return this.servicesByName.values().iterator();
    }

    public void addNonProtectedURI(URIMatcher uri) {
        this.nonProtectedURIs.add(uri);
    }

    public void addProtectedURI(URIMatcher uri) {
        this.protectedURIs.add(uri);
    }

    public boolean isProtectedURI(String uri, Map httpParamsMap) {
        boolean isProtected;
        if (this.protectedURIs == null || this.protectedURIs.isEmpty()) {
            isProtected = true;
        } else {
            isProtected = false;
            for (URIMatcher uriMatcher : this.protectedURIs) {
                if (!uriMatcher.matches(uri, httpParamsMap)) continue;
                isProtected = true;
                break;
            }
        }
        if (this.nonProtectedURIs == null || this.nonProtectedURIs.isEmpty()) {
            return isProtected;
        }
        for (URIMatcher uriMatcher : this.nonProtectedURIs) {
            if (!uriMatcher.matches(uri, httpParamsMap)) continue;
            isProtected = false;
        }
        return isProtected;
    }

    private static class GatekeeperConfigHolder {
        private static GatekeeperConfig instance = new GatekeeperConfig();

        private GatekeeperConfigHolder() {
        }
    }
}

