/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.URIMatcher;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class GatekeeperServiceConfig {
    private static final Logger log = Logger.getLogger(GatekeeperServiceConfig.class);
    public static final String SERVICE_NAME_DEFAULT = "default";
    public static final int SERVICE_TYPE_CALL_OUT = 0;
    public static final int SERVICE_TYPE_CALL_IN = 1;
    public static final int SERVICE_TYPE_CALL_INOUT = 2;
    public static final int SERVICE_PROTECTION_LEVEL_SOAP = 0;
    public static final int SERVICE_PROTECTION_LEVEL_BROWSER = 1;
    public static final int SERVICE_PROTECTION_LEVEL_ALL = 2;
    protected String name;
    protected int type;
    protected int protectionLevel;
    protected RPURI rpuri;
    protected Hashtable httpTokenPolicies;
    protected HashSet serviceURIMatchers;
    protected URIMatcher logoutURIMatcher;
    protected CoreConfig coreConfig;
    protected Hashtable wsTokenPolicies;

    public GatekeeperServiceConfig() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.name = null;
        this.rpuri = null;
        this.type = 1;
        this.protectionLevel = 2;
        this.coreConfig = null;
        this.logoutURIMatcher = null;
        this.serviceURIMatchers = new HashSet();
        this.httpTokenPolicies = new Hashtable();
        this.wsTokenPolicies = new Hashtable();
        this.httpTokenPolicies.put("*", new SAML1Policy());
        this.wsTokenPolicies.put("*", new SAML1Policy());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    public void setProtectionLevel(int protectionLevel) {
        this.protectionLevel = protectionLevel;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    public void setCoreConfig(CoreConfig coreConfig) {
        this.coreConfig = coreConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RPURI getRpuri() {
        return this.rpuri;
    }

    public void setRpuri(RPURI rpuri) {
        this.rpuri = rpuri;
    }

    public boolean matchesLogoutURI(String uri, Map httpParamsMap) {
        if (this.logoutURIMatcher == null) {
            return false;
        }
        return this.logoutURIMatcher.matches(uri, httpParamsMap);
    }

    public void setLogoutURI(URIMatcher logoutURIMatcher) {
        this.logoutURIMatcher = logoutURIMatcher;
    }

    public void addServiceURI(URIMatcher uri) {
        this.serviceURIMatchers.add(uri);
    }

    public boolean matchServiceURI(String uri, Map httpParamsMap) {
        if (this.serviceURIMatchers == null) {
            return false;
        }
        if (this.serviceURIMatchers.iterator() == null) {
            return false;
        }
        if (!this.serviceURIMatchers.iterator().hasNext()) {
            return false;
        }
        for (URIMatcher uriMatcher : this.serviceURIMatchers) {
            if (!uriMatcher.matches(uri, httpParamsMap)) continue;
            return true;
        }
        return false;
    }

    public SAML1Policy getHttpTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy httpTokenPolicy = (SAML1Policy)this.httpTokenPolicies.get(tokenType);
        if (httpTokenPolicy == null) {
            httpTokenPolicy = (SAML1Policy)this.httpTokenPolicies.get("*");
        }
        return httpTokenPolicy;
    }

    public void addHttpTokenPolicy(String tokenType, SAML1Policy httpTokenPolicy) {
        this.httpTokenPolicies.put(tokenType, httpTokenPolicy);
    }

    public SAML1Policy getWsTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get(tokenType);
        if (wsTokenPolicy == null) {
            wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get("*");
        }
        return wsTokenPolicy;
    }

    public void addWsTokenPolicy(String tokenType, SAML1Policy wsTokenPolicy) {
        this.wsTokenPolicies.put(tokenType, wsTokenPolicy);
    }
}

