/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.UIDGenerator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTSerializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTCancelRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SAML1Token;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.soap.secctx.SecCtxFilterToLogonAppOutgoing;

public class HTTPRequestHandlerWSFedRedirectHelper {
    private static final Logger log = Logger.getLogger(HTTPRequestHandlerWSFedRedirectHelper.class);
    public static final int WSFED_ACTION_LOGIN = 1;
    public static final int WSFED_ACTION_LOGOUT = 2;

    public static void loginRedirect(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig) throws ServletException, SSOException {
        HTTPRequestHandlerWSFedRedirectHelper.redirectToFederationServices(req, resp, serviceConfig, 1, null);
    }

    public static void logoutRedirect(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, SSOToken cancelSSOToken) throws ServletException, SSOException {
        HTTPRequestHandlerWSFedRedirectHelper.redirectToFederationServices(req, resp, serviceConfig, 2, cancelSSOToken);
    }

    private static void redirectToFederationServices(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, int action, SSOToken cancelTarget) throws ServletException, SSOException {
        CoreConfig coreConfig = serviceConfig.getCoreConfig();
        String principal = null;
        if (action == 1 && req.getUserPrincipal() != null) {
            boolean usePrincipal = coreConfig.getBooleanParameter("UsePrincipalUserIfPresent", false);
            boolean isAllowedAuthnType = coreConfig.isAllowedPreauthenticationType(req.getAuthType());
            if (usePrincipal && isAllowedAuthnType) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using principal user: " + req.getUserPrincipal().getName() + "/" + req.getAuthType()));
                }
                principal = req.getUserPrincipal().getName();
            } else {
                log.warn((Object)("Principal user is found on the request but authentication type is not allowed: " + req.getUserPrincipal().getName() + "/" + req.getAuthType()));
            }
        }
        String fullRequestURL = req.getRequestURL().toString();
        String requestURLNoQuery = req.getRequestURL().toString();
        String requestQuery = req.getQueryString();
        if (requestQuery != null) {
            fullRequestURL = fullRequestURL + "?";
            fullRequestURL = fullRequestURL + requestQuery;
        }
        String axis2repo = FileIOHelper.normalizePath((String)coreConfig.getParameter("axis2repo", "${APPROOT_DIR}/WEB-INF"));
        String axis2xml = FileIOHelper.normalizePath((String)coreConfig.getParameter("axis2xml", "${CONFIG_DIR}/axis2.xml"));
        String fedRequestPayloadMethod = coreConfig.getParameter("FederationRequestPayloadMethod", "rpuri");
        long remoteDataTTL = coreConfig.getLongParameter("RemoteDataTTL", 60L);
        long requestTokenTTL = coreConfig.getLongParameter("SecurityTokenTTL", 28800L);
        boolean forceRemoteData = coreConfig.getBooleanParameter("ForceRemoteDataInWSFederation", false);
        int maxUrlLen = coreConfig.getIntParameter("RemoteDataMaxURLLength", 260);
        String fedServerURL = coreConfig.getParameter("FederationServerURL", "");
        RPURI rpuri = serviceConfig.getRpuri();
        String requestString = null;
        if (fedRequestPayloadMethod.equals("soap-rst") || fedRequestPayloadMethod.equals("rst") || StringHelper.isNotBlank((String)principal)) {
            boolean forceSOAP = fedRequestPayloadMethod.equals("soap-rst");
            if (action == 1) {
                RSTIssueRequest issueRequest = new RSTIssueRequest();
                issueRequest.setSSOTokenType("http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT");
                issueRequest.setAppliesTo(serviceConfig.getRpuri().toString());
                SecCtxFilterToLogonAppOutgoing secCtx = new SecCtxFilterToLogonAppOutgoing();
                secCtx.setOfcUsername(principal);
                secCtx.setOfcPassword(null);
                issueRequest.setSecurityContext((SecurityContext)secCtx);
                issueRequest.setTtl(requestTokenTTL);
                issueRequest.setEpr(fedServerURL);
                requestString = HTTPRequestHandlerWSFedRedirectHelper.serializeRSTRequest((RSTRequest)issueRequest, forceSOAP, axis2repo, axis2xml);
            } else {
                RSTCancelRequest cancelRequest = new RSTCancelRequest();
                SAML1Token target = WSAbstractFactory.getWSSEObjectFactory().createSAML1Token(cancelTarget.getNativeObject());
                cancelRequest.setSecurityToken((SignedSecurityToken)target);
                cancelRequest.setEpr(fedServerURL);
                requestString = HTTPRequestHandlerWSFedRedirectHelper.serializeRSTRequest((RSTRequest)cancelRequest, forceSOAP, axis2repo, axis2xml);
            }
        } else {
            forceRemoteData = false;
        }
        String requestUUID = UIDGenerator.getUUID();
        String requestUUIDKey = RemoteDataStorage.getInstance().addData((Object)requestUUID, remoteDataTTL);
        String requestContext = WSFedHelper.createContextString((String)requestUUIDKey, (String)requestUUID);
        WSFedData wsfData = WSFedHelper.generateWSFSignInRequestData((String)fullRequestURL, (String)requestContext, requestString, (String)rpuri.toString());
        String targetURL = fedServerURL;
        String urlString = WSFedHelper.generateRedirectURL((String)targetURL, (WSFedData)wsfData);
        if ((urlString.length() >= maxUrlLen || forceRemoteData) && StringHelper.isNotBlank((String)wsfData.getWreq())) {
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.addData((Object)wsfData.getWreq(), remoteDataTTL);
            String remoteDataURL = serviceConfig.getCoreConfig().getRemoteDataURL(requestURLNoQuery, req.getServerPort());
            wsfData = WSFedHelper.convertWreqToWreqptr((String)remoteDataURL, (String)rdKey, (WSFedData)wsfData);
            urlString = WSFedHelper.generateRedirectURL((String)targetURL, (WSFedData)wsfData);
        }
        resp.encodeRedirectURL(urlString);
        try {
            resp.sendRedirect(urlString);
        }
        catch (IOException e) {
            log.error((Object)("Error redirecting to " + urlString), (Throwable)e);
        }
    }

    public static String serializeRSTRequest(RSTRequest request, boolean forceSOAPGeneration, String axis2repo, String axis2xml) throws SSOException {
        String requestString = null;
        if (request.getSecurityContext().getOfcUsername() == null && !forceSOAPGeneration) {
            requestString = request.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created RST request:" + requestString));
            }
        } else {
            RSTSerializer serializer = new RSTSerializer(axis2repo, axis2xml);
            serializer.setEpr(new EndpointReference(request.getEpr()));
            requestString = serializer.createSOAPMessage(request);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created RST request:" + requestString));
            }
        }
        return requestString;
    }
}

