/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;

public class SOAPRequestHandler {
    static final Logger log = Logger.getLogger(SOAPRequestHandler.class);

    public ALFSSOPrincipal processSOAPMessage(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, SOAPEnvelope soapEnvelope) throws ServletException, SSOException {
        boolean useStrictSOAPRoleChecking;
        CoreConfig coreConfig = serviceConfig.getCoreConfig();
        String rpURI = serviceConfig.getRpuri().toString();
        SSOToken token = SOAPHelper.extractSSOTokenFromSOAPMessage((SOAPEnvelope)soapEnvelope, (String)rpURI);
        if (token == null && !(useStrictSOAPRoleChecking = coreConfig.getBooleanParameter("UseStrictRoleCheckingInIncomingSOAPMessages", false))) {
            token = SOAPHelper.extractSSOTokenFromSOAPMessage((SOAPEnvelope)soapEnvelope, (String)"");
        }
        if (token == null) {
            SOAPEnvelope fault = SOAPHelper.generateSOAPFault((SOAPEnvelope)soapEnvelope, null, (String)rpURI);
            SOAPHelper.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
            log.error((Object)"Authentication failed: failed to extract token");
            return null;
        }
        String tokenType = token.getTokenType();
        if (tokenType == null) {
            SOAPEnvelope fault = SOAPHelper.generateSOAPFault((SOAPEnvelope)soapEnvelope, null, (String)rpURI);
            SOAPHelper.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
            log.error((Object)"Authentication failed - failed to extract token type");
            return null;
        }
        SAML1Policy profilePolicy = serviceConfig.getWsTokenPolicy(tokenType);
        if (profilePolicy == null) {
            SOAPEnvelope fault = SOAPHelper.generateSOAPFault((SOAPEnvelope)soapEnvelope, null, (String)rpURI);
            SOAPHelper.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
            log.error((Object)("Authentication failed - could not find token profile validation policy for this token type: " + tokenType));
            return null;
        }
        ExtendedResult rc = token.validateToken((SSOTokenPolicy)profilePolicy);
        if (!rc.isSuccess()) {
            SOAPEnvelope fault = SOAPHelper.generateSOAPFault((SOAPEnvelope)soapEnvelope, (ExtendedResult)rc, (String)rpURI);
            SOAPHelper.returnSOAPFault((HttpServletResponse)resp, (SOAPEnvelope)fault);
            log.info((Object)"Authentication failed - could not load token profile policy");
            return null;
        }
        return new ALFSSOPrincipal(token);
    }
}

