/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private Action sampleAction;

    public MultiPageEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor iTextEditor, String string) {
        return iTextEditor == null ? null : iTextEditor.getAction(string);
    }

    public void setActivePage(IEditorPart iEditorPart) {
        if (this.activeEditorPart == iEditorPart) {
            return;
        }
        this.activeEditorPart = iEditorPart;
        IActionBars iActionBars = this.getActionBars();
        if (iActionBars != null) {
            ITextEditor iTextEditor = iEditorPart instanceof ITextEditor ? (ITextEditor)iEditorPart : null;
            iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.DELETE));
            iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.UNDO));
            iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.REDO));
            iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.CUT));
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.COPY));
            iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.PASTE));
            iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.SELECT_ALL));
            iActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.FIND));
            iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(iTextEditor, IDEActionFactory.BOOKMARK.getId()));
            iActionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.sampleAction = new Action(){

            public void run() {
                MessageDialog.openInformation(null, (String)"ALFPlugin Plug-in", (String)"Sample Action Executed");
            }
        };
        this.sampleAction.setText("Sample Action");
        this.sampleAction.setToolTipText("Sample Action tool tip");
        this.sampleAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("Editor &Menu");
        iMenuManager.prependToGroup("additions", (IContributionItem)menuManager);
        menuManager.add((IAction)this.sampleAction);
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.sampleAction);
    }
}

