/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SOAPActionMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SimpleStringMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcher;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class GatekeeperServiceConfig {
    private static final Logger log = Logger.getLogger(GatekeeperServiceConfig.class);
    public static final String SERVICE_NAME_DEFAULT = "default";
    public static final int SERVICE_TYPE_CALL_OUT = 0;
    public static final int SERVICE_TYPE_CALL_IN = 1;
    public static final int SERVICE_TYPE_CALL_INOUT = 2;
    public static final int SERVICE_PROTECTION_LEVEL_SOAP = 0;
    public static final int SERVICE_PROTECTION_LEVEL_BROWSER = 1;
    public static final int SERVICE_PROTECTION_LEVEL_ALL = 2;
    protected String name;
    protected int type;
    protected int protectionLevel;
    protected RPURI rpuri;
    protected Hashtable httpTokenPolicies;
    protected ArrayList browserURIMatchers;
    protected ArrayList dmzbrowserURIMatchers;
    protected ArrayList soapURIMatchers;
    protected ArrayList dmzsoapURIMatchers;
    protected ArrayList soapActionMatchers;
    protected ArrayList dmzSOAPActionMatchers;
    protected URIMatcher globalLogoutURIMatcher;
    protected URIMatcher localLogoutURIMatcher;
    protected CoreConfig coreConfig;
    protected Hashtable wsTokenPolicies;

    public GatekeeperServiceConfig() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.name = null;
        this.rpuri = null;
        this.type = 1;
        this.protectionLevel = 2;
        this.coreConfig = null;
        this.globalLogoutURIMatcher = null;
        this.localLogoutURIMatcher = null;
        this.browserURIMatchers = new ArrayList();
        this.dmzbrowserURIMatchers = new ArrayList();
        this.soapURIMatchers = new ArrayList();
        this.dmzsoapURIMatchers = new ArrayList();
        this.soapActionMatchers = new ArrayList();
        this.dmzSOAPActionMatchers = new ArrayList();
        this.httpTokenPolicies = new Hashtable();
        this.wsTokenPolicies = new Hashtable();
        this.httpTokenPolicies.put("*", new SAML1Policy());
        this.wsTokenPolicies.put("*", new SAML1Policy());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    public void setProtectionLevel(int protectionLevel) {
        this.protectionLevel = protectionLevel;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    public void setCoreConfig(CoreConfig coreConfig) {
        this.coreConfig = coreConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RPURI getRpuri() {
        return this.rpuri;
    }

    public void setRpuri(RPURI rpuri) {
        this.rpuri = rpuri;
    }

    public boolean matchesGlobalLogoutURI(String uri, Map httpParamsMap) {
        if (this.globalLogoutURIMatcher == null) {
            return false;
        }
        return this.globalLogoutURIMatcher.matches(uri, httpParamsMap);
    }

    public boolean matchesLocalLogoutURI(String uri, Map httpParamsMap) {
        if (this.localLogoutURIMatcher == null) {
            return false;
        }
        return this.localLogoutURIMatcher.matches(uri, httpParamsMap);
    }

    public void setGlobalLogoutURI(URIMatcher globalLogoutURIMatcher) {
        this.globalLogoutURIMatcher = globalLogoutURIMatcher;
    }

    public void setLocalLogoutURI(URIMatcher localLogoutURIMatcher) {
        this.localLogoutURIMatcher = localLogoutURIMatcher;
    }

    public void addBrowserServiceURIMatcher(URIMatcher uri) {
        this.browserURIMatchers.add(uri);
    }

    public void addDMZBrowserServiceURIMatcher(URIMatcher uri) {
        this.dmzbrowserURIMatchers.add(uri);
    }

    public void addSOAPServiceURIMather(URIMatcher uri) {
        this.soapURIMatchers.add(uri);
    }

    public void addDMZSOAPServiceURIMatcher(URIMatcher uri) {
        this.dmzsoapURIMatchers.add(uri);
    }

    public void addSOAPActionMatcher(SOAPActionMatcher soapAction) {
        this.soapActionMatchers.add(soapAction);
    }

    public void addDMZSOAPActionMatcher(SOAPActionMatcher soapAction) {
        this.dmzSOAPActionMatchers.add(soapAction);
    }

    public boolean matchBrowserRequestURI(String uri, Map httpParamsMap) {
        return this.genericURIMatch(this.browserURIMatchers, uri, httpParamsMap);
    }

    public boolean matchDMZBrowserRequestURI(String uri, Map httpParamsMap) {
        return this.genericURIMatch(this.dmzbrowserURIMatchers, uri, httpParamsMap);
    }

    public boolean matchSOAPRequest(String uri, Map httpParamsMap, String soapAction) {
        boolean matches = this.genericURIMatch(this.soapURIMatchers, uri, httpParamsMap);
        if (soapAction != null) {
            matches &= this.genericSimpleStringMatch(this.soapActionMatchers, soapAction);
        }
        return matches;
    }

    public boolean matchDMZSOAPRequest(String uri, Map httpParamsMap, String soapAction) {
        boolean matches = this.genericURIMatch(this.dmzsoapURIMatchers, uri, httpParamsMap);
        if (soapAction != null) {
            matches &= this.genericSimpleStringMatch(this.dmzSOAPActionMatchers, soapAction);
        }
        return matches;
    }

    private boolean genericURIMatch(List list, String uri, Map httpParamsMap) {
        Iterator it;
        if (list != null && (it = list.iterator()) != null) {
            while (it.hasNext()) {
                URIMatcher uriMatcher = (URIMatcher)it.next();
                if (!uriMatcher.matches(uri, httpParamsMap)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean genericSimpleStringMatch(List list, String string) {
        Iterator it;
        if (list != null && (it = list.iterator()) != null) {
            while (it.hasNext()) {
                SimpleStringMatcher simpleStringMatcher = (SimpleStringMatcher)it.next();
                if (!simpleStringMatcher.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    public SAML1Policy getHttpTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy httpTokenPolicy = (SAML1Policy)this.httpTokenPolicies.get(tokenType);
        if (httpTokenPolicy == null) {
            httpTokenPolicy = (SAML1Policy)this.httpTokenPolicies.get("*");
        }
        return httpTokenPolicy;
    }

    public void addHttpTokenPolicy(String tokenType, SAML1Policy httpTokenPolicy) {
        this.httpTokenPolicies.put(tokenType, httpTokenPolicy);
    }

    public SAML1Policy getWsTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get(tokenType);
        if (wsTokenPolicy == null) {
            wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get("*");
        }
        return wsTokenPolicy;
    }

    public void addWsTokenPolicy(String tokenType, SAML1Policy wsTokenPolicy) {
        this.wsTokenPolicies.put(tokenType, wsTokenPolicy);
    }
}

