/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl;

public class FederationServicesResponseHelper {
    private static final Logger log = Logger.getLogger(FederationServicesResponseHelper.class);

    public static WSFedData extractWSFedDataFromRequest(HttpServletRequest req, HttpServletResponse resp) {
        WSFedData wsfData = WSFedHelper.getWSFDataFromRequestParameters((HttpServletRequest)req);
        if (wsfData.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting WS-Fed Response. wsfData is empty");
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Extracting WS-Fed Response. wsfData successfully extracted from HTTP request object");
        }
        return wsfData;
    }

    public static ExtendedResult validateWSFedResponseProfile(WSFedData wsfData) {
        WSFedDataValidator wsfDataValidator;
        ExtendedResult wsfDataValidationResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering validateWSFedResponseProfile()");
        }
        if (!(wsfDataValidationResult = (wsfDataValidator = WSFedDataObjectFactory.createWSFedDataValidator()).validateResponse(wsfData, false)).isSuccess()) {
            log.error((Object)("WS-Federation response validation failed: " + wsfDataValidationResult.getMessage()));
        }
        return wsfDataValidationResult;
    }

    public static boolean isWSFedResponseDataRemoted(WSFedData wsfData) throws SSOException {
        if (StringHelper.isBlank((String)wsfData.getWresult()) && StringHelper.isNotBlank((String)wsfData.getWresultptr())) {
            try {
                new URL(wsfData.getWresultptr());
            }
            catch (MalformedURLException e) {
                log.error((Object)("Invalid URL in [wresultptr]: \"" + wsfData.getWresultptr() + "\""), (Throwable)e);
                throw new SSOException("Invalid URL in [wresultptr]: \"" + wsfData.getWresultptr() + "\"", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static WSFedData extractWSFedRemotedData(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData) throws SSOException, ServletException {
        String remotedData = null;
        String remoteContentURL = wsfData.getWresultptr();
        RemoteDataClientImpl remoteContentClient = new RemoteDataClientImpl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting remoted WS-Federation content from \"" + remoteContentURL + "\""));
        }
        try {
            remotedData = remoteContentClient.getRemoteContent(remoteContentURL, null);
        }
        catch (SSOException e) {
            log.error((Object)("Error extracting remoted data from \"" + remoteContentURL + "\""));
            throw e;
        }
        if (remotedData == null) {
            log.error((Object)"Error acquiring remote content: empty content returned");
            throw new SSOException("Error acquiring wresult via wresultptr = " + remoteContentURL);
        }
        if (remotedData.trim().length() == 0) {
            log.error((Object)"Remote content returned empty string");
            return null;
        }
        wsfData.setWresult(remotedData);
        wsfData.setWresultptr(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remote content successfuly extracted: \"" + remotedData + "\""));
        }
        return wsfData;
    }
}

