/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.TokenExchangeHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandlerTokenExtractionHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandlerWSFedRedirectHelper;
import org.eclipse.alf.security.sso.server.gatekeeper.html.HTMLFactory;

public class HTTPRequestHandler {
    static final Logger log = Logger.getLogger(HTTPRequestHandler.class);
    private static final int TOKEN_SOURCE_NONE = 0;
    private static final int TOKEN_SOURCE_FEDERATION_PARAMS = 1;
    private static final int TOKEN_SOURCE_COOKIES = 2;
    private static final int TOKEN_SOURCE_HTTP_HEADERS = 3;

    public static ALFSSOPrincipal processHTTPRequest(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, WSFedData wsfData) throws ServletException, SSOException {
        SAML1Policy tokenPolicy;
        ExtendedResult validationResult;
        log.debug((Object)"Entering authenticate()");
        CoreConfig serviceCoreConfig = serviceConfig.getCoreConfig();
        SSOToken payloadToken = null;
        String errorMessage = null;
        int payloadSource = 0;
        boolean useTokensInHeaders = serviceCoreConfig.getBooleanParameter("UseTokensInHeaders", true);
        boolean useTokensInCookies = serviceCoreConfig.getBooleanParameter("UseTokensInCookies", true);
        if (wsfData != null) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromWSFedSignInActionData(req, resp, serviceConfig, wsfData);
                payloadSource = 1;
            }
            catch (SSOException e) {
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceCoreConfig, "Error processing federation services response", e.getMessage());
                return null;
            }
        }
        if (useTokensInHeaders) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromHTTPHeader(req, resp);
                payloadSource = 3;
            }
            catch (SSOException e) {
                return null;
            }
        }
        if (useTokensInCookies) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromCookies(req, resp, serviceConfig);
                payloadSource = 2;
            }
            catch (SSOException e) {
                return null;
            }
        }
        boolean globalLogoutRequest = serviceConfig.matchesGlobalLogoutURI(req.getRequestURI(), req.getParameterMap());
        boolean localLogoutRequest = serviceConfig.matchesLocalLogoutURI(req.getRequestURI(), req.getParameterMap());
        if (payloadToken == null) {
            if (globalLogoutRequest || localLogoutRequest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Logout request but no valid token found. Letting through with a (null) principal");
                }
                return new ALFSSOPrincipal();
            }
            HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
            return null;
        }
        if (globalLogoutRequest) {
            HTTPRequestHandlerWSFedRedirectHelper.logoutRedirect(req, resp, serviceConfig, payloadToken);
            return null;
        }
        if (localLogoutRequest) {
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
            ArrayList cookies = cookieManager.createCookie(cookieData);
            CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, (ArrayList)cookies);
            return new ALFSSOPrincipal(null, payloadToken.getSubjectName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validating SSO token against token validation policy");
        }
        if (!(validationResult = payloadToken.validateToken((SSOTokenPolicy)(tokenPolicy = serviceConfig.getHttpTokenPolicy(payloadToken.getTokenType())))).isSuccess()) {
            boolean validationFailureWaiver = false;
            if (payloadSource == 1) {
                errorMessage = "Validation of WS-Federation token failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                log.error((Object)errorMessage);
                HTMLFactory.setApplicationErrorResponse(req, resp, serviceCoreConfig, "Error obtaining security token", errorMessage);
                return null;
            }
            if (validationResult.getCode() == 10) {
                log.info((Object)"Validating SSO token against token validation policy failed: token expired");
                boolean useFederationServerForRenew = serviceCoreConfig.getBooleanParameter("UseFederationServerForRenew", true);
                if (useFederationServerForRenew) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Redirecting to login (always use federation services");
                    }
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                try {
                    payloadToken = TokenExchangeHelper.getSSOTokenWithExpiredToken(payloadToken, serviceConfig.getRpuri().toString());
                }
                catch (SSOException e) {
                    errorMessage = "Error requesting security token from STS:" + e.getMessage();
                    log.error((Object)errorMessage, (Throwable)e);
                    log.debug((Object)"Redirecting to login");
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                log.debug((Object)"Validating SSO token against token validation policy");
                tokenPolicy = serviceConfig.getHttpTokenPolicy(payloadToken.getTokenType());
                validationResult = payloadToken.validateToken((SSOTokenPolicy)tokenPolicy);
                if (!validationResult.isSuccess()) {
                    errorMessage = "New ALF SSO token aquired successfully, but validation failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                    log.error((Object)errorMessage);
                    HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                    return null;
                }
                validationFailureWaiver = true;
            }
            if (!validationFailureWaiver) {
                errorMessage = "Found ALF SSO token, but validation failed with code " + validationResult.getCode() + ":" + payloadToken.toString();
                log.error((Object)errorMessage);
                HTTPRequestHandlerWSFedRedirectHelper.loginRedirect(req, resp, serviceConfig);
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ALF SSO token validated OK: " + payloadToken.getSubjectName()));
        }
        if (payloadSource != 2) {
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
            ArrayList cookies = cookieManager.createCookie(cookieData);
            CookieHTTPHelper.addCokiesToResponse((HttpServletResponse)resp, (ArrayList)cookies);
        }
        return new ALFSSOPrincipal(payloadToken.toString(), payloadToken.getSubjectName());
    }
}

