/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.filterloader.ALFSSOPrincipal;
import org.eclipse.alf.security.sso.server.gatekeeper.handler.HTTPRequestHandlerTokenExtractionHelper;

public class HTTPSignOutRequestHandler {
    private static final Logger log = Logger.getLogger(HTTPSignOutRequestHandler.class);

    public HTTPSignOutRequestHandler() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public static ALFSSOPrincipal processSignout(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig, WSFedData wsfData) throws ServletException, SSOException {
        boolean tokenCanceledConfirmation = false;
        if (wsfData != null) {
            tokenCanceledConfirmation = HTTPRequestHandlerTokenExtractionHelper.extractIsTokenCanceledFromWSFedSignOutActionData(req, resp, serviceConfig, wsfData);
        }
        if (!tokenCanceledConfirmation) {
            return null;
        }
        CoreConfig serviceCoreConfig = serviceConfig.getCoreConfig();
        boolean useTokensInCookies = serviceCoreConfig.getBooleanParameter("UseTokensInCookies", true);
        SSOToken payloadToken = null;
        if (useTokensInCookies) {
            try {
                payloadToken = HTTPRequestHandlerTokenExtractionHelper.extractSSOTokenFromCookies(req, resp, serviceConfig);
            }
            catch (SSOException e) {
                return null;
            }
        }
        if (payloadToken != null) {
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            CookieData cookieData = cookieManager.createCookieData(serviceConfig.getRpuri(), payloadToken, req.getRemoteAddr());
            ArrayList cookies = cookieManager.createCookie(cookieData);
            CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, (ArrayList)cookies);
            return new ALFSSOPrincipal(null, payloadToken.getSubjectName());
        }
        return null;
    }
}

