/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class PrincipalEndorsmentConfigBuilder {
    private static final Logger log = Logger.getLogger(PrincipalEndorsmentConfigBuilder.class);
    public static final String PRINCIPAL_ENDORSMENT_METHODS_LN = "PrincipalEndorsmentMethods";
    public static final String USERNAME_CREDENTIAL_LN = "UsernameCredential";
    public static final String USERNAME_LN = "Username";
    public static final String PASSWORD_LN = "Password";
    public static final String X509CERTSIGNATURE_CREDENTIAL_LN = "X509CertificateSignature";
    public static final String KEYSTORE_ID_LN = "KeystoreId";
    public static final String CERTIFICATE_ALIAS_LN = "CertificateAlias";
    public static final String CERTIFICATE_PASSWORD_CREDENTIAL_LN = "CertificatePassword";
    public static final String CERTIFICATE_INCLUSION_METHOD_LN = "CertificateInclusionMethod";

    public PrincipalEndorsmentConfigBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public PrincipalEndorsmentConfig build(OMElement element) {
        OMElement signatureCredentialEl;
        PrincipalEndorsmentConfig retVal = new PrincipalEndorsmentConfig();
        if (element == null) {
            return retVal;
        }
        if (!element.getLocalName().equals(PRINCIPAL_ENDORSMENT_METHODS_LN)) {
            log.error((Object)("Invalid configuration element <" + element.getLocalName() + "> when expectin <" + PRINCIPAL_ENDORSMENT_METHODS_LN + ">"));
            return null;
        }
        OMElement usernameCredentialEl = element.getFirstChildWithName(new QName(USERNAME_CREDENTIAL_LN));
        if (usernameCredentialEl != null) {
            retVal.setType(1);
            OMElement usernameEl = usernameCredentialEl.getFirstChildWithName(new QName(USERNAME_LN));
            String username = null;
            if (usernameEl != null) {
                username = usernameEl.getText();
            }
            OMElement passwordEl = usernameCredentialEl.getFirstChildWithName(new QName(PASSWORD_LN));
            String password = null;
            if (passwordEl != null) {
                password = passwordEl.getText();
            }
            if (StringHelper.isBlank(username)) {
                log.error((Object)"Username empty in endorsing credentials configuration, skipping configuration");
            } else {
                if (StringHelper.isEmpty(password)) {
                    password = "";
                }
                retVal.setUsername(username);
                retVal.setPassword(password);
                retVal.setType(1);
            }
        }
        if ((signatureCredentialEl = element.getFirstChildWithName(new QName(X509CERTSIGNATURE_CREDENTIAL_LN))) != null) {
            OMElement keystoreIdEl = signatureCredentialEl.getFirstChildWithName(new QName(KEYSTORE_ID_LN));
            String keystoreId = null;
            if (keystoreIdEl != null) {
                keystoreId = keystoreIdEl.getText();
            }
            OMElement certificateAliasEl = signatureCredentialEl.getFirstChildWithName(new QName(CERTIFICATE_ALIAS_LN));
            String alias = null;
            if (certificateAliasEl != null) {
                alias = certificateAliasEl.getText();
            }
            OMElement certificatePasswordEl = signatureCredentialEl.getFirstChildWithName(new QName(CERTIFICATE_PASSWORD_CREDENTIAL_LN));
            String certPassword = null;
            if (certificatePasswordEl != null) {
                certPassword = certificatePasswordEl.getText();
            }
            OMElement certificateInclusionMethodEl = signatureCredentialEl.getFirstChildWithName(new QName(CERTIFICATE_INCLUSION_METHOD_LN));
            String certInclusionMethod = null;
            if (!(certificateInclusionMethodEl == null || (certInclusionMethod = certificateInclusionMethodEl.getText()).equals("DirectReference") || certInclusionMethod.equals("IssuerSerial") || certInclusionMethod.equals("X509KeyIdentifier") || certInclusionMethod.equals("SKIKeyIdentifier") || certInclusionMethod.equals("EmbeddedKeyName") || certInclusionMethod.equals("Thumbprint"))) {
                certInclusionMethod = "DirectReference";
            }
            if (StringHelper.isNotBlank(keystoreId) && StringHelper.isNotBlank(alias) && StringHelper.isNotBlank(certPassword) && StringHelper.isNotBlank(certInclusionMethod)) {
                retVal.setKeystoreId(keystoreId);
                retVal.setCertAlias(alias);
                retVal.setSigningCertPassword(certPassword);
                retVal.setCertInclusionMethod(certInclusionMethod);
                if (retVal.getType() == 1) {
                    retVal.setType(3);
                } else {
                    retVal.setType(2);
                }
            }
        }
        return retVal;
    }
}

