/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcherHttpParamSet;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class URIMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(URIMatcher.class);
    public static final String DEFAULT_REQUEST_URI = "*";
    public static final String DEFAULT_REQUEST_URI_JAVAREGEX = ".*";
    private String requestURI;
    private HashSet httpParamSetSet;
    private Pattern requestURIPattern;

    public URIMatcher() {
        this.reset();
    }

    public URIMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public URIMatcher(int matcherType, String requestURI, HashSet httpParamSetSet) throws SSOException {
        super(matcherType);
        this.reset();
        this.requestURI = requestURI;
        this.httpParamSetSet = httpParamSetSet;
        if (matcherType == 2) {
            try {
                this.requestURIPattern = Pattern.compile(requestURI);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + requestURI + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
        }
    }

    public void reset() {
        this.requestURI = DEFAULT_REQUEST_URI;
        this.httpParamSetSet = new HashSet();
        if (this.matcherType == 2) {
            try {
                this.requestURIPattern = Pattern.compile(this.requestURI);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public boolean matches(String uri, Map httpParamsMap) {
        Matcher uriMatcher;
        if (this.matcherType == 2 ? (uriMatcher = this.requestURIPattern.matcher(uri)) == null || !uriMatcher.matches() : !StringHelper.basicWildcardMatch(this.requestURI, uri)) {
            return false;
        }
        if (httpParamsMap == null) {
            return true;
        }
        HashMap matchedParamsCache = new HashMap();
        Iterator it = this.httpParamSetSet.iterator();
        if (it != null) {
            if (!it.hasNext()) {
                return true;
            }
            while (it.hasNext()) {
                URIMatcherHttpParamSet matchParamSet = (URIMatcherHttpParamSet)it.next();
                if (!matchParamSet.matches(httpParamsMap, matchedParamsCache)) continue;
                return true;
            }
        }
        return false;
    }

    public void addHttpParamSet(URIMatcherHttpParamSet httpParamSet) {
        this.httpParamSetSet.add(httpParamSet);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) throws SSOException {
        if (StringHelper.isBlank(requestURI)) {
            this.requestURI = DEFAULT_REQUEST_URI;
        }
        this.requestURI = requestURI;
        if (this.matcherType == 2) {
            try {
                this.requestURIPattern = Pattern.compile(requestURI);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + requestURI;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.httpParamSetSet.isEmpty()) {
            sb.append(this.requestURI);
            return sb.toString();
        }
        for (URIMatcherHttpParamSet paramSet : this.httpParamSetSet) {
            sb.append("[");
            sb.append(this.requestURI);
            sb.append("?");
            sb.append(paramSet.toString());
            sb.append("],");
        }
        String retVal = sb.toString();
        retVal = retVal.substring(0, retVal.length() - 2);
        return retVal;
    }
}

