/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcherHttpParamSet;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.AbstractMatcherBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class URIMatcherBuilder
extends AbstractMatcherBuilder {
    private static final Logger log = Logger.getLogger(URIMatcherBuilder.class);
    public static final String URI_MATCHER_LN = "URIMatcher";
    public static final String ATTR_REQUEST_URI_LN = "requestURI";
    public static final String HTTP_PARAM_SET_LN = "HttpParamSet";
    public static final String HTTP_PARAM_LN = "HttpParam";
    public static final String NAME_LN = "Name";
    public static final String VALUE_LN = "Value";

    public URIMatcherBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public String getLocalName() {
        return URI_MATCHER_LN;
    }

    public AbstractMatcher build(OMElement element) throws SSOException {
        if (element == null) {
            return null;
        }
        if (!element.getLocalName().equals(this.getLocalName())) {
            return null;
        }
        String requestURI = XMLHelper.getAttribute(element, ATTR_REQUEST_URI_LN);
        String comparer = XMLHelper.getAttribute(element, "comparer");
        URIMatcher retVal = StringHelper.isBlank(comparer) ? new URIMatcher(1) : (comparer.equals("basic") ? new URIMatcher(1) : (comparer.equals("regex") ? new URIMatcher(2) : new URIMatcher(1)));
        if (StringHelper.isBlank(requestURI)) {
            return null;
        }
        retVal.setRequestURI(requestURI);
        Iterator httpParamSetIt = element.getChildrenWithName(new QName(HTTP_PARAM_SET_LN));
        while (httpParamSetIt != null && httpParamSetIt.hasNext()) {
            OMElement httpParamSetEl = (OMElement)httpParamSetIt.next();
            URIMatcherHttpParamSet httpParamSet = new URIMatcherHttpParamSet();
            Iterator httpParamIt = httpParamSetEl.getChildrenWithName(new QName(HTTP_PARAM_LN));
            while (httpParamIt != null && httpParamIt.hasNext()) {
                String name;
                OMElement nameEl;
                String defaultValue;
                int matcherType;
                OMElement httpParamEl = (OMElement)httpParamIt.next();
                comparer = XMLHelper.getAttribute(httpParamEl, "comparer");
                if (StringHelper.isBlank(comparer)) {
                    matcherType = 1;
                    defaultValue = "*";
                } else if (comparer.equals("basic")) {
                    matcherType = 1;
                    defaultValue = "*";
                } else if (comparer.equals("regex")) {
                    matcherType = 2;
                    defaultValue = ".*";
                } else {
                    matcherType = 1;
                    defaultValue = "*";
                }
                if ((nameEl = httpParamEl.getFirstChildWithName(new QName(NAME_LN))) == null || !StringHelper.isNotBlank(name = nameEl.getText())) continue;
                Iterator valueIt = httpParamEl.getChildrenWithName(new QName(NAME_LN));
                if (valueIt == null || !valueIt.hasNext()) {
                    httpParamSet.addMatchHttpParamSet(matcherType, name, "*");
                    break;
                }
                while (valueIt.hasNext()) {
                    OMElement valueEl = (OMElement)valueIt.next();
                    String value = valueEl.getText();
                    value = StringHelper.isBlank(value) ? "*" : valueEl.getText();
                    httpParamSet.addMatchHttpParamSet(matcherType, name, defaultValue);
                }
            }
            if (httpParamSet.isEmpty()) continue;
            retVal.addHttpParamSet(httpParamSet);
        }
        return retVal;
    }
}

