/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.io.IOException;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOConfigSecretDataCallback;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameter;
import org.eclipse.alf.security.sso.common.http.configuration.ConfigParameterMap;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.CoreConfigBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class ConfigParameterMapBuilder {
    private static final Logger log = Logger.getLogger(ConfigParameterMapBuilder.class);
    public static final String CONFIG_PARAM_LN = "parameter";
    public static final String CONFIG_SECRET_PARAM_LN = "SecretParameter";
    public static final String CONFIG_PARAM_NAME_ATTR = "name";
    public static final String SECRET_PARAM_ID_ATTR = "id";
    public static final String SECRET_PARAM_VALUE_PROPERTY_NAME_ATTR = "valuePropertyName";
    public static final String SECRET_PARAM_VALUE_CALLBACK_ATTR = "valueCallback";
    protected String basePath = null;

    public ConfigParameterMapBuilder() {
    }

    public ConfigParameterMapBuilder(String basePath) {
        this.basePath = basePath;
    }

    public ConfigParameterMap build(OMElement el) {
        return this.build(el, null, true);
    }

    public ConfigParameterMap build(OMElement el, ConfigParameterMap baseParams) {
        return this.build(el, baseParams, true);
    }

    public ConfigParameterMap build(OMElement el, ConfigParameterMap baseParams, boolean loadIncludes) {
        ConfigParameterMap retVal = null;
        retVal = baseParams == null ? new ConfigParameterMap() : baseParams;
        Iterator iterator = el.getChildElements();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String includeFilename;
                Iterator it;
                OMElement currentElement = (OMElement)iterator.next();
                if (currentElement.getLocalName().equals(CONFIG_SECRET_PARAM_LN)) {
                    String value = null;
                    String id = XMLHelper.getAttribute(currentElement, SECRET_PARAM_ID_ATTR);
                    String property = XMLHelper.getAttribute(currentElement, SECRET_PARAM_VALUE_PROPERTY_NAME_ATTR);
                    String callbackClassName = XMLHelper.getAttribute(currentElement, SECRET_PARAM_VALUE_CALLBACK_ATTR);
                    boolean valueAquired = false;
                    if (StringHelper.isNotBlank(callbackClassName)) {
                        if (StringHelper.isNotBlank(id)) {
                            CallbackHandler cbHandler;
                            block24: {
                                cbHandler = null;
                                ClassLoader classLoader = this.getClass().getClassLoader();
                                log.debug((Object)("loading class : " + callbackClassName));
                                try {
                                    Class<?> cbClass = null;
                                    cbClass = classLoader.loadClass(callbackClassName);
                                    if (cbClass == null) break block24;
                                    cbHandler = (CallbackHandler)cbClass.newInstance();
                                }
                                catch (ClassNotFoundException e) {
                                    log.error((Object)("Failed to load class \"" + callbackClassName + "\" : class not found. Skipping propery."));
                                    continue;
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error while trying to load class \"" + callbackClassName + "\". Skipping propery."), (Throwable)e);
                                    continue;
                                }
                            }
                            Callback[] callbacks = new Callback[]{new SSOConfigSecretDataCallback(id, 2)};
                            try {
                                cbHandler.handle(callbacks);
                            }
                            catch (IOException e) {
                                log.error((Object)"Failed to extract secret value from callback. Skipping propery.", (Throwable)e);
                                continue;
                            }
                            catch (UnsupportedCallbackException e) {
                                log.error((Object)"Unsupported callback exception was caught while handling secret property value callback. Skipping propery.", (Throwable)e);
                                continue;
                            }
                            value = ((SSOConfigSecretDataCallback)callbacks[0]).getSecret();
                            valueAquired = true;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Set secret parameter value returned from callback class \"" + callbackClassName + "\""));
                            }
                        }
                        if (!valueAquired && StringHelper.isNotBlank(property)) {
                            try {
                                value = System.getProperty(property);
                                valueAquired = true;
                            }
                            catch (SecurityException e) {
                                log.error((Object)"Security exception caught while trying to access system property. Skipping propery.");
                                continue;
                            }
                        }
                        currentElement.setLocalName(CONFIG_PARAM_LN);
                        currentElement.setText(StringHelper.toNotNullString(value));
                    } else {
                        log.error((Object)"<SecretParameter> parameter contains an @valueCallback attribute but @id is not present. Cannot call callback with parameteridentifing attribute. Skipping propery.");
                        continue;
                    }
                }
                if (currentElement.getLocalName().equals(CONFIG_PARAM_LN)) {
                    ConfigParameter parameter = new ConfigParameter();
                    parameter.setElement(currentElement);
                    String name = XMLHelper.getAttribute(currentElement, CONFIG_PARAM_NAME_ATTR);
                    if (StringHelper.isBlank(name)) continue;
                    parameter.setName(name.trim());
                    OMElement parameterValue = null;
                    it = currentElement.getChildElements();
                    if (it != null && it.hasNext()) {
                        parameterValue = (OMElement)it.next();
                    }
                    if (parameterValue != null) {
                        parameter.setValue(parameterValue);
                        parameter.setType(2);
                    } else {
                        String value = currentElement.getText();
                        parameter.setValue(value);
                        parameter.setType(1);
                    }
                    retVal.addOrReplaceParameter(parameter);
                    continue;
                }
                if (!loadIncludes || !currentElement.getLocalName().equals("include") || !StringHelper.isNotBlank(includeFilename = XMLHelper.getAttribute(currentElement, "file"))) continue;
                CoreConfigBuilder tempCoreConfigBuilder = new CoreConfigBuilder(this.basePath);
                tempCoreConfigBuilder.setLoadIncludedFiles(false);
                tempCoreConfigBuilder.setInitializeCookieManager(false);
                tempCoreConfigBuilder.setInstantiateRemoteDataClient(false);
                tempCoreConfigBuilder.setLoadKeystores(false);
                try {
                    CoreConfig tempCoreConfig = tempCoreConfigBuilder.build(includeFilename);
                    if (tempCoreConfig != null) {
                        it = tempCoreConfig.getAllParameters();
                        if (it == null) continue;
                        while (it.hasNext()) {
                            retVal.addOrReplaceParameter((ConfigParameter)it.next());
                        }
                        continue;
                    }
                    log.error((Object)("Failed to load include file: \"" + includeFilename + "\""));
                }
                catch (SSOException e) {
                    log.error((Object)("Failed to load sub-configuration: \"" + includeFilename + "\""));
                }
            }
        }
        return retVal;
    }
}

