/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class SimpleStringMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(SimpleStringMatcher.class);
    public static final String DEFAULT_REGEX_STRING = "*";
    public static final String DEFAULT_REGEX_STRING_JAVAREGEX = ".*";
    protected String regexString;
    protected Pattern regexPattern;

    public SimpleStringMatcher() {
        this.reset();
    }

    public SimpleStringMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public SimpleStringMatcher(int matcherType, String regexString) throws SSOException {
        super(matcherType);
        this.reset();
        this.regexString = regexString;
        if (matcherType == 2) {
            try {
                this.regexPattern = Pattern.compile(regexString);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + regexString + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
        }
    }

    public void reset() {
        this.regexString = DEFAULT_REGEX_STRING;
        if (this.matcherType == 2) {
            try {
                this.regexPattern = Pattern.compile(this.regexString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public boolean matches(String matchString) {
        if (this.matcherType == 2) {
            Matcher matcher = this.regexPattern.matcher(matchString);
            return matcher != null && matcher.matches();
        }
        return StringHelper.basicWildcardMatch(this.regexString, matchString);
    }

    public String getRegexString() {
        return this.regexString;
    }

    public void setRegexString(String regexString) throws SSOException {
        if (StringHelper.isBlank(regexString)) {
            this.regexString = DEFAULT_REGEX_STRING;
        }
        this.regexString = regexString;
        if (this.matcherType == 2) {
            try {
                this.regexPattern = Pattern.compile(regexString);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + regexString;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String toString() {
        return this.regexString;
    }
}

