/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class URIMatcherHttpParam {
    private static final Logger log = Logger.getLogger(URIMatcherHttpParam.class);
    public static final String DEFAULT_PARAM_NAME = "*";
    public static final String DEFAULT_PARAM_VALUE = "*";
    public static final String DEFAULT_PARAM_NAME_REGEX = ".*";
    public static final String DEFAULT_PARAM_VALUE_JAVAREGEX = ".*";
    public static final int MATCHER_TYPE_BASIC = 1;
    public static final int MATCHER_TYPE_REGEX = 2;
    private String name;
    private String value;
    private int matcherType;
    private Pattern paramNamePattern;
    private Pattern paramValuePattern;

    public URIMatcherHttpParam(int matcherType) throws SSOException {
        this.matcherType = matcherType;
        this.name = "*";
        this.value = "*";
        if (matcherType == 2) {
            try {
                this.paramNamePattern = Pattern.compile(this.name);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + this.name;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
            try {
                this.paramValuePattern = Pattern.compile(this.value);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter value regex: " + this.value;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public URIMatcherHttpParam(int matcherType, String name, String value) throws SSOException {
        this.matcherType = matcherType;
        String defaultParamName = matcherType == 1 ? "*" : ".*";
        String defaultParamValue = matcherType == 1 ? "*" : ".*";
        this.name = StringHelper.isBlank(name) ? defaultParamName : name;
        this.value = StringHelper.isBlank(value) ? defaultParamValue : value;
        if (matcherType == 2) {
            try {
                this.paramNamePattern = Pattern.compile(name);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + name;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
            try {
                this.paramValuePattern = Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter value regex: " + value;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getParamName() {
        return this.name;
    }

    public void setParamName(String paramName) throws SSOException {
        if (StringHelper.isBlank(paramName)) {
            paramName = this.matcherType == 1 ? "*" : ".*";
        } else {
            this.name = paramName;
        }
        if (this.matcherType == 2) {
            try {
                this.paramNamePattern = Pattern.compile(paramName);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter name regex: " + paramName;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getParamValue() {
        return this.value;
    }

    public void setParamValue(String paramValue) throws SSOException {
        if (StringHelper.isBlank(paramValue)) {
            paramValue = this.matcherType == 1 ? "*" : ".*";
        } else {
            this.value = paramValue;
        }
        if (this.matcherType == 2) {
            try {
                this.paramValuePattern = Pattern.compile(paramValue);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set parameter value regex: " + paramValue;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public boolean matches(String paramName, String paramValue) {
        if (paramValue == null) {
            paramValue = "";
        }
        if (this.matcherType == 2) {
            Matcher valueMatcher;
            Matcher nameMatcher = this.paramNamePattern.matcher(paramName);
            return nameMatcher != null && nameMatcher.matches() && (valueMatcher = this.paramValuePattern.matcher(paramValue)) != null && valueMatcher.matches();
        }
        return StringHelper.basicWildcardMatch(this.name, paramName) && StringHelper.basicWildcardMatch(this.value, paramValue);
    }

    public boolean matchesName(String paramName) {
        if (this.matcherType == 2) {
            Matcher nameMatcher = this.paramNamePattern.matcher(paramName);
            return nameMatcher != null && nameMatcher.matches();
        }
        return StringHelper.basicWildcardMatch(this.name, paramName);
    }

    public boolean matchesValue(String paramValue) {
        if (this.matcherType == 2) {
            Matcher valueMatcher = this.paramValuePattern.matcher(paramValue);
            return valueMatcher != null && valueMatcher.matches();
        }
        return StringHelper.basicWildcardMatch(this.value, paramValue);
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

