/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.saml.SAML1Attribute;
import org.opensaml.SAMLAttribute;

public class SAML1AttributeImpl
implements SAML1Attribute {
    private static final Logger log = Logger.getLogger(SAML1AttributeImpl.class);
    protected long lifetime;
    protected String name;
    protected String namespaceURI;
    protected QName type;
    protected List values;

    public SAML1AttributeImpl() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public SAML1AttributeImpl(String name, String namespaceURI, String value) {
        this.reset();
        this.name = name;
        this.namespaceURI = namespaceURI;
        this.values.add(value);
    }

    public SAML1AttributeImpl(SAMLAttribute assertionAttribute) {
        this.reset();
        this.name = assertionAttribute.getName();
        this.namespaceURI = assertionAttribute.getNamespace();
        this.lifetime = assertionAttribute.getLifetime();
        this.type = assertionAttribute.getType();
        Iterator attrValues = assertionAttribute.getValues();
        if (attrValues != null) {
            while (attrValues.hasNext()) {
                Object value = attrValues.next();
                if (!(value instanceof String)) continue;
                this.values.add((String)value);
            }
        }
    }

    public void reset() {
        this.lifetime = 0L;
        this.name = "";
        this.namespaceURI = "";
        this.values = new ArrayList();
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String ns) {
        this.namespaceURI = ns;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = type;
    }

    public String getValue() {
        if (this.values.get(0) != null) {
            return (String)this.values.get(0);
        }
        return null;
    }

    public void setValue(String value) {
        this.values.clear();
        this.values.add(value);
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public boolean hasValue(String value) {
        Iterator it = this.values.iterator();
        if (it != null) {
            while (it.hasNext()) {
                String next = (String)it.next();
                if (!value.equals(next)) continue;
                return true;
            }
        }
        return false;
    }

    public void setValues(List values) {
        this.values = values;
    }
}

