/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;

public class TrustPolicy
extends BasePolicy {
    private static final Logger log = Logger.getLogger(TrustPolicy.class);
    public static final boolean DEFAULT_ENFORCED = true;
    protected Set trustedIssuerURIs;
    protected List trustedIssuerCertificateAliases;
    protected Set trustedSubjectNames;
    protected List trustedSubjectCertificateAliases;

    public TrustPolicy() {
    }

    public TrustPolicy(SAML1Policy contextPolicy) {
        super(contextPolicy);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.trustedIssuerURIs = new HashSet();
        this.trustedIssuerCertificateAliases = new ArrayList();
        this.trustedSubjectNames = new HashSet();
        this.trustedSubjectCertificateAliases = new ArrayList();
    }

    public static boolean getIsEnforcedByDefault() {
        return true;
    }

    public Set getTrustedIssuerURIs() {
        return this.trustedIssuerURIs;
    }

    public void setTrustedIssuerURIs(Set trustedIssuerURIs) {
        this.trustedIssuerURIs = trustedIssuerURIs;
    }

    public void addTrustedIssuerURI(String issuerURI) {
        this.trustedIssuerURIs.add(issuerURI);
    }

    public List getTrustedIssuerCertificateAliases() {
        return this.trustedIssuerCertificateAliases;
    }

    public void setTrustedIssuerCertificates(List trustedIssuerCertificateAliases) {
        this.trustedIssuerCertificateAliases = trustedIssuerCertificateAliases;
    }

    public void addTrustedIssuerCertificateAlias(CertAlias trustedIssuerCertificateAlias) {
        this.trustedIssuerCertificateAliases.add(trustedIssuerCertificateAlias);
    }

    public Set getTrustedSubjectNames() {
        return this.trustedSubjectNames;
    }

    public void setTrustedSubjectNames(Set trustedSubjectNames) {
        this.trustedSubjectNames = trustedSubjectNames;
    }

    public void addTrustedSubjectName(String trustedSubjectName) {
        this.trustedSubjectNames.add(trustedSubjectName);
    }

    public List getTrustedSubjectCertificateAliases() {
        return this.trustedSubjectCertificateAliases;
    }

    public void setTrustedSubjectCertificates(List trustedSubjectCertificateAliases) {
        this.trustedSubjectCertificateAliases = trustedSubjectCertificateAliases;
    }

    public void addTrustedSubjectCertificateAlias(CertAlias trustedSubjectCertificateAlias) {
        this.trustedSubjectCertificateAliases.add(trustedSubjectCertificateAlias);
    }

    public class CertAlias {
        private String alias = null;
        private String keystoreId = null;

        private CertAlias() {
        }

        public CertAlias(String alias, String keystoreId) {
            this.alias = alias;
            this.keystoreId = keystoreId;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getKeystoreId() {
            return this.keystoreId;
        }
    }
}

