/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.token.saml.policy.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.token.saml.policy.BasePolicy;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public abstract class BasePolicyBuilder {
    private static final Logger log = Logger.getLogger(BasePolicyBuilder.class);
    public static final String ATTR_ENFORCE = "enforce";
    public static final String ATTR_OVERRIDE = "override";

    public abstract String getLocalName();

    public String getAttribute(OMElement el, String attributeName) {
        if (el == null) {
            log.error((Object)"Invalid argument: null");
            return null;
        }
        if (!el.getLocalName().equals(this.getLocalName())) {
            log.error((Object)("Invlaid argument: element <" + el.getLocalName() + "> encountered when expecting <" + this.getLocalName() + ">"));
            return null;
        }
        if (StringHelper.isBlank(attributeName)) {
            log.error((Object)"Invlaid argument: attribute name is empty");
            return null;
        }
        OMAttribute enforcedAttr = el.getAttribute(new QName(attributeName));
        if (enforcedAttr != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("@" + attributeName + " attribute parsed: " + enforcedAttr.getAttributeValue()));
            }
            return enforcedAttr.getAttributeValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("@" + attributeName + " attribute is missing"));
        }
        return null;
    }

    public abstract BasePolicy build(OMElement var1) throws SSOException;

    public abstract BasePolicy build(OMElement var1, BasePolicy var2) throws SSOException;
}

