/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;

public class WSTrust {
    static final Logger log = Logger.getLogger((String)WSTrust.class.getName());
    public static final int V1 = 1;
    public static final int V2 = 2;
    public static final int V3 = 3;
    public static final String WST_V1_NAMESPACE = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String WST_V2_NAMESPACE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final String WST_V3_NAMESPACE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final String WST_DEFAULT_PREFIX = "wst";
    public ActionsClass Actions = null;
    public RequestTypesClass RequestTypes = null;
    public ValidationStatusCodesClass validationStatusCodes = null;
    protected WSTrustVersion version;
    protected String namespace;
    protected WSTrustObjectFactory objectFactory = null;

    private void init(WSTrustVersion version) {
        this.version = version;
        if (version == WSTrustVersion.V1) {
            this.namespace = WST_V1_NAMESPACE;
        } else if (version == WSTrustVersion.V2) {
            this.namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        } else if (version == WSTrustVersion.V3) {
            this.namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
        } else {
            throw new IllegalArgumentException();
        }
        this.Actions = new ActionsClass(this);
        this.RequestTypes = new RequestTypesClass(this);
        this.objectFactory = new WSTrustObjectFactory(this);
        this.validationStatusCodes = new ValidationStatusCodesClass(this);
    }

    public WSTrust() {
        this.init(WSTrustVersion.V1);
    }

    public WSTrust(WSTrustVersion version) {
        this.init(version);
    }

    public WSTrustVersion getVersion() {
        return this.version;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public OMNamespace getOMNamespace() {
        return OMAbstractFactory.getOMFactory().createOMNamespace(this.getNamespace(), WSTrust.getPrefix());
    }

    public static String getPrefix() {
        return WST_DEFAULT_PREFIX;
    }

    public static boolean isSupportedNamespace(String namespace) {
        if (namespace.equals(WST_V1_NAMESPACE)) {
            return true;
        }
        if (namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            return true;
        }
        return namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512");
    }

    public static WSTrust createFromNamespace(String namespace) {
        if (namespace.equals(WST_V1_NAMESPACE)) {
            return new WSTrust(WSTrustVersion.V1);
        }
        if (namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            return new WSTrust(WSTrustVersion.V2);
        }
        if (namespace.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            return new WSTrust(WSTrustVersion.V3);
        }
        return null;
    }

    public String getActionFromRequestType(String requestType) {
        if (requestType.equals(this.RequestTypes.getIssue())) {
            return this.Actions.getRequestSecurityTokenIssue();
        }
        if (requestType.equals(this.RequestTypes.getCancel())) {
            return this.Actions.getRequestSecurityTokenCancel();
        }
        if (requestType.equals(this.RequestTypes.getRenew())) {
            return this.Actions.getRequestSecurityTokenResponseRenew();
        }
        if (requestType.equals(this.RequestTypes.getRenew())) {
            return this.Actions.getRequestSecurityTokenResponseRenew();
        }
        return null;
    }

    public OMElement createOMElement(String elementLocalName) {
        return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, this.getNamespace(), WSTrust.getPrefix());
    }

    public static OMElement createOMElement(WSTrustVersion version, String elementLocalName) {
        if (version == WSTrustVersion.V1) {
            return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, WST_V1_NAMESPACE, WSTrust.getPrefix());
        }
        if (version == WSTrustVersion.V2) {
            return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", WSTrust.getPrefix());
        }
        if (version == WSTrustVersion.V3) {
            return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", WSTrust.getPrefix());
        }
        return null;
    }

    public OMElement createOMElement(OMElement parent, String elementLocalName) {
        if (parent == null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            return fac.createOMElement(elementLocalName, this.getNamespace(), WSTrust.getPrefix());
        }
        return XMLHelper.createOMElement(parent, this.getNamespace(), elementLocalName, WSTrust.getPrefix());
    }

    public OMElement createOMElement(WSTrustVersion version, OMElement parent, String elementLocalName) {
        if (version == WSTrustVersion.V1) {
            if (parent == null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                return fac.createOMElement(elementLocalName, WST_V1_NAMESPACE, WSTrust.getPrefix());
            }
            return XMLHelper.createOMElement(parent, WST_V1_NAMESPACE, elementLocalName, WSTrust.getPrefix());
        }
        if (version == WSTrustVersion.V2) {
            if (parent == null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                return fac.createOMElement(elementLocalName, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", WSTrust.getPrefix());
            }
            return XMLHelper.createOMElement(parent, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", elementLocalName, WSTrust.getPrefix());
        }
        if (version == WSTrustVersion.V3) {
            if (parent == null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                return fac.createOMElement(elementLocalName, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", WSTrust.getPrefix());
            }
            return XMLHelper.createOMElement(parent, "http://docs.oasis-open.org/ws-sx/ws-trust/200512", elementLocalName, WSTrust.getPrefix());
        }
        return null;
    }

    public WSTrustObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public static WSTrustVersion isKnownElement(String localname) {
        if (StringHelper.isBlank(localname)) {
            return null;
        }
        if ("AllowPostdating".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("AuthenticationType".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Authenticator".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("BinaryExchange".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("BinarySecret".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("CancelTarget".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("CanonicalizationAlgorithm".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Challenge".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Claims".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Code".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("CombinedHash".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("ComputedKey".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("ComputedKeyAlgorithm".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Delegatable".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("DelegateTo".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Encryption".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("EncryptionAlgorithm".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("EncryptWith".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Entropy".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Forwardable".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("IssuedTokens".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Issuer".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("KeySize".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("KeyExchangeToken".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("KeyType".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("KeyWrapAlgorithm".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Lifetime".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("OnBehalfOf".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Participant".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Participants".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Primary".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("ProofEncryption".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Reason".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Renewing".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RenewTarget".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestedAttachedReference".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestedProofToken".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestedSecurityToken".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestedTokenCancelled".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestedUnattachedReference".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestKET".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestSecurityToken".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestSecurityTokenCollection".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestSecurityTokenResponse".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestSecurityTokenResponseCollection".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("RequestType".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SecondaryParameters".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SignatureAlgorithm".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SignChallenge".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SignChallengeResponse".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SignWith".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Status".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("TokenType".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("UseKey".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("ValidateTarget".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("SecurityTokenReference".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("Reference".equals(localname)) {
            return WSTrustVersion.V1;
        }
        if ("URI".equals(localname)) {
            return WSTrustVersion.V1;
        }
        return null;
    }

    public class FaultCodes {
        public static final String INVALID_REQUEST = "wst:InvalidRequest";
        public static final String FAILED_AUTHENTICATION = "wst:FailedAuthentication";
        public static final String REQUEST_FAILED = "wst:RequestFailed";
        public static final String INVALID_SECUIRITY_TOKEN = "wst:InvalidSecurityToken";
        public static final String AUTHENTICATION_BAD_ELEMENTS = "wst:AuthenticationBadElements";
        public static final String BAD_REQUEST = "wst:BadRequest";
        public static final String EXPIRED_DATA = "wst:ExpiredData";
        public static final String INVALID_TIME_RANGE = "wst:InvalidTimeRange";
        public static final String INVALID_SCOPE = "wst:InvalidScope";
        public static final String RENEW_NEEDED = "wst:RenewNeeded";
        public static final String UNABLE_TO_RENEW = "wst:UnableToRenew";
    }

    public class ValidationStatusCodesClass {
        private String ns = null;

        private ValidationStatusCodesClass(WSTrust wst) {
            this.ns = wst.getNamespace();
        }

        public String getStatusValid() {
            return this.ns + "/status/valid";
        }

        public String getStatusInvalid() {
            return this.ns + "/status/invalid";
        }
    }

    public class ActionsClass {
        private String ns = null;

        private ActionsClass(WSTrust wst) {
            this.ns = wst.getNamespace();
        }

        public String getRequestSecurityContextToken() {
            return this.ns + "/RST/SCT";
        }

        public String getRequestSecurityContextTokenIssue() {
            return this.ns + "/RST/SCT/Issue";
        }

        public String getRequestSecurityContextTokenAmend() {
            return this.ns + "/RST/SCT/Amend";
        }

        public String getRequestSecurityContextTokenCancel() {
            return this.ns + "/RST/SCT/Cancel";
        }

        public String getRequestSecurityContextTokenResponse() {
            return this.ns + "/RSTR/SCT";
        }

        public String getRequestSecurityContextTokenResponseIssue() {
            return this.ns + "/RSTR/SCT/Issue";
        }

        public String getRequestSecurityContextTokenResponseAmend() {
            return this.ns + "/RSTR/SCT/Amend";
        }

        public String getRequestSecurityContextTokenResponseCancel() {
            return this.ns + "/RSTR/SCT/Cancel";
        }

        public String getRequestSecurityTokenIssue() {
            return this.ns + "/RST/Issue";
        }

        public String getRequestSecurityTokenCancel() {
            return this.ns + "/RST/Cancel";
        }

        public String getRequestSecurityTokenSTSCancel() {
            return this.ns + "/RST/STSCancel";
        }

        public String getRequestSecurityTokenRenew() {
            return this.ns + "/RST/Renew";
        }

        public String getRequestSecurityTokenValidate() {
            return this.ns + "/RST/Validate";
        }

        public String getRequestSecurityTokenKET() {
            return this.ns + "/RST/KET";
        }

        public String getRequestSecurityTokenResponseIssue() {
            return this.ns + "/RSTR/Issue";
        }

        public String getRequestSecurityTokenResponseCancel() {
            return this.ns + "/RSTR/Cancel";
        }

        public String getRequestSecurityTokenResponseCancelFinal() {
            return this.ns + "/RSTR/CancelFinal";
        }

        public String getRequestSecurityTokenResponseRenew() {
            return this.ns + "/RSTR/Renew";
        }

        public String getRequestSecurityTokenResponseRenewFinal() {
            return this.ns + "/RSTR/RenewFinal";
        }

        public String getRequestSecurityTokenResponseValidate() {
            return this.ns + "/RSTR/Validate";
        }

        public String getRequestSecurityTokenResponseValidateFinal() {
            return this.ns + "/RSTR/ValidateFinal";
        }

        public String getRequestSecurityTokenResponseKET() {
            return this.ns + "/RSTR/KET";
        }

        public String getRequestSecurityTokenResponseCollectionIssueFinal() {
            return this.ns + "/RSTRC/IssueFinal";
        }
    }

    public static class TokenTypes {
        public static final String SAML_ASSERTION_V1 = "urn:oasis:names:tc:SAML:1.0:assertion#Assertion";
        public static final String SAML_ASSERTION_V2 = "urn:oasis:names:tc:SAML:2.0:assertion#Assertion";
        public static final String USERNAMETOKEN = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
        public static final String X509V3TOKEN = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
        public static final String WSTRUST_STATUS = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status";
    }

    public static class RequestTypesClass {
        private String ns = null;

        private RequestTypesClass(WSTrust wst) {
            this.ns = wst.getNamespace();
        }

        public String getIssue() {
            return this.ns + "/Issue";
        }

        public String getValidate() {
            return this.ns + "/Validate";
        }

        public String getRenew() {
            return this.ns + "/Renew";
        }

        public String getCancel() {
            return this.ns + "/Cancel";
        }

        public String getSTSCancel() {
            return this.ns + "/STSCancel";
        }

        public String getBatchIssue() {
            return this.ns + "/BatchIssue";
        }

        public String getBatchValidate() {
            return this.ns + "/BatchValidate";
        }

        public String getBatchRenew() {
            return this.ns + "/BatchRenew";
        }

        public String getBatchCancel() {
            return this.ns + "/BatchCancel";
        }

        public String getKET() {
            return this.ns + "/KET";
        }
    }

    public static class ElementNames {
        public static final String ALLOW_POSTDATING = "AllowPostdating";
        public static final String AUTHENTICATION_TYPE = "AuthenticationType";
        public static final String AUTHENTICATOR = "Authenticator";
        public static final String BINARY_EXCHANGE = "BinaryExchange";
        public static final String BINARY_SECRET = "BinarySecret";
        public static final String CANCEL_TARGET = "CancelTarget";
        public static final String CANONICALIZATION_ALGORITHM = "CanonicalizationAlgorithm";
        public static final String CHALLENGE = "Challenge";
        public static final String CLAIMS = "Claims";
        public static final String CODE = "Code";
        public static final String COMBINED_HASH = "CombinedHash";
        public static final String COMPUTED_KEY = "ComputedKey";
        public static final String COMPUTED_KEY_ALGORITHM = "ComputedKeyAlgorithm";
        public static final String DELEGATABLE = "Delegatable";
        public static final String DELEGATE_TO = "DelegateTo";
        public static final String ENCRYPTION = "Encryption";
        public static final String ENCRYPTION_ALGORITHM = "EncryptionAlgorithm";
        public static final String ENCRYPT_WITH = "EncryptWith";
        public static final String ENTROPY = "Entropy";
        public static final String FORWARDABLE = "Forwardable";
        public static final String ISSUED_TOKENS = "IssuedTokens";
        public static final String ISSUER = "Issuer";
        public static final String KEY_SIZE = "KeySize";
        public static final String KEY_EXCHANGE_TOKEN = "KeyExchangeToken";
        public static final String KEY_TYPE = "KeyType";
        public static final String KEY_WRAP_ALGORITHM = "KeyWrapAlgorithm";
        public static final String LIFETIME = "Lifetime";
        public static final String ON_BEHALF_OF = "OnBehalfOf";
        public static final String PARTICIPANT = "Participant";
        public static final String PARTICIPANTS = "Participants";
        public static final String PRIMARY = "Primary";
        public static final String PROOF_ENCRYPTION = "ProofEncryption";
        public static final String REASON = "Reason";
        public static final String RENEWING = "Renewing";
        public static final String RENEW_TARGET = "RenewTarget";
        public static final String REQUESTED_ATTACHED_REFERENCE = "RequestedAttachedReference";
        public static final String REQUESTED_PROOF_TOKEN = "RequestedProofToken";
        public static final String REQUESTED_SECURITY_TOKEN = "RequestedSecurityToken";
        public static final String REQUESTED_TOKEN_CANCELLED = "RequestedTokenCancelled";
        public static final String REQUESTED_UNATTACHED_REFERENCE = "RequestedUnattachedReference";
        public static final String REQUEST_KET = "RequestKET";
        public static final String REQUEST_SECURITY_TOKEN = "RequestSecurityToken";
        public static final String REQUEST_SECURITY_TOKEN_COLLECTION = "RequestSecurityTokenCollection";
        public static final String REQUEST_SECURITY_TOKEN_RESPONSE = "RequestSecurityTokenResponse";
        public static final String REQUEST_SECURITY_TOKEN_RESPONSE_COLLECTION = "RequestSecurityTokenResponseCollection";
        public static final String REQUEST_TYPE = "RequestType";
        public static final String SECONDARY_PARAMETERS = "SecondaryParameters";
        public static final String SIGNATURE_ALGORITHM = "SignatureAlgorithm";
        public static final String SIGN_CHALLENGE = "SignChallenge";
        public static final String SIGN_CHALLENGE_RESPONSE = "SignChallengeResponse";
        public static final String SIGN_WITH = "SignWith";
        public static final String STATUS = "Status";
        public static final String TOKEN_TYPE = "TokenType";
        public static final String USE_KEY = "UseKey";
        public static final String VALIDATE_TARGET = "ValidateTarget";
        public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
        public static final String REFERENCE = "Reference";
        public static final String URI = "URI";
    }
}

