/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;

public class PageRedirector {
    private static Logger log = Logger.getLogger(PageRedirector.class);
    public static final String RD_PARAM = "rd";
    public static final String METHOD_PARAM = "rm";
    public static final String METHOD_ATTR = "redirectMethod";
    private static final String ERROR_MSG_STR_ATTR = "errorMessage";
    FedSrvRPConfig rpConfig = null;

    private PageRedirector() {
    }

    public PageRedirector(FedSrvRPConfig rpConfig) {
        this.rpConfig = rpConfig;
    }

    public void redirectAppError(HttpServletRequest req, HttpServletResponse resp, String errorMessage) throws ServletException {
        log.info((Object)("Redirecting to application error page. error=\"" + errorMessage + "\""));
        String page = this.rpConfig.getCoreConfig().getParameter("PageError", "jsp/appError.jsp");
        req.setAttribute(ERROR_MSG_STR_ATTR, (Object)errorMessage);
        RequestDispatcher rd = req.getRequestDispatcher(page);
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to app error page: " + e));
            throw new ServletException();
        }
    }

    public void redrectDirectFobidden(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        log.debug((Object)"Redirecting to 'direct access forbidden' page");
        String page = this.rpConfig.getCoreConfig().getParameter("PageDirectAccessForbidden", "jsp/directAccessForbidden.jsp");
        if (StringHelper.isBlank((String)page)) {
            try {
                resp.sendError(403, "Please use single-sign-on enabled application to login");
            }
            catch (IOException e) {
                String errorMessage = "Error forwarding to 'direct access forbidden' page";
                log.error((Object)errorMessage, (Throwable)e);
                throw new ServletException(errorMessage, (Throwable)e);
            }
        }
        RequestDispatcher rd = req.getRequestDispatcher(page);
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to 'direct access forbidden' page: " + e));
            throw new ServletException();
        }
    }

    public void redrectBack(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData, boolean formLoginUsed) throws ServletException {
        CoreConfig coreConfig = this.rpConfig.getCoreConfig();
        String redirectMethod = coreConfig.getParameter("HttpRedirectMethod", "GET");
        if (StringHelper.isBlank((String)redirectMethod) || !redirectMethod.equalsIgnoreCase("GET") && !redirectMethod.equalsIgnoreCase("POST")) {
            log.error((Object)"Invalid value for parameter \"HttpRedirectMethod\": only \"POST\" and \"GET\" are allowed values. Defaulting to \"GET\"");
            redirectMethod = "GET";
        }
        String pageRedirect = coreConfig.getParameter("PageRedirect", "jsp/postRedirect.jsp");
        boolean httpRedirectSecWarnAvoidance = this.rpConfig.getCoreConfig().getBooleanParameter("HttpRedirectHttpsSecurityWarningAvoidance", true);
        boolean forceRemoteData = coreConfig.getBooleanParameter("ForceRemoteDataInWSFederation", false);
        int maxUrlLen = coreConfig.getIntParameter("RemoteDataMaxURLLength", 260);
        long remoteDataTTL = coreConfig.getLongParameter("RemoteDataTTL", 60L);
        String remoteDataURI = coreConfig.getParameter("RemoteDataServerEPR", "");
        String redirectTarget = pageRedirect;
        WSFedHelper.setWSFDataAsAttributes((HttpServletRequest)req, (WSFedData)wsfData);
        req.setAttribute(METHOD_ATTR, (Object)redirectMethod);
        if (req.isSecure() && httpRedirectSecWarnAvoidance) {
            Integer httpConnectorPort;
            try {
                String httpConnectorPortStr = this.rpConfig.getCoreConfig().getParameter("HttpRedirectConnectorPort", "80");
                httpConnectorPort = httpConnectorPortStr.trim().length() == 0 ? null : Integer.valueOf(httpConnectorPortStr);
            }
            catch (NumberFormatException e) {
                try {
                    httpConnectorPort = Integer.valueOf("80");
                }
                catch (NumberFormatException ee) {
                    log.error((Object)"This should never happen.");
                    httpConnectorPort = null;
                }
            }
            String url = req.getRequestURL().toString();
            String servletPath = req.getServletPath();
            int offset = url.indexOf(servletPath);
            String prefix = url.substring(0, offset);
            URL prefixURL = null;
            try {
                prefixURL = new URL(prefix);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
            URL newPrefixURL = null;
            try {
                newPrefixURL = httpConnectorPort == null ? new URL("http", prefixURL.getHost(), prefixURL.getFile()) : new URL("http", prefixURL.getHost(), httpConnectorPort, prefixURL.getFile());
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
            redirectTarget = newPrefixURL.toString() + "/" + pageRedirect;
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.addData((Object)wsfData, remoteDataTTL);
            redirectTarget = redirectTarget + "?" + RD_PARAM + "=" + rdKey;
            redirectTarget = redirectTarget + "&" + METHOD_PARAM + "=" + redirectMethod;
            try {
                resp.sendRedirect(redirectTarget);
            }
            catch (IOException e) {
                log.error((Object)("Error forwarding to app error page: " + e));
                throw new ServletException();
            }
        }
        try {
            RequestDispatcher rd = req.getRequestDispatcher(redirectTarget);
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error forwarding to app error page: " + e));
            throw new ServletException();
        }
    }

    public void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext, String message) throws ServletException {
        log.debug((Object)("Entering. message=" + message));
        HttpSession session = req.getSession();
        String loginPage = this.rpConfig.getCoreConfig().getParameter("PageLogin", "jsp/login.jsp");
        RequestDispatcher rd = req.getRequestDispatcher(loginPage);
        session = req.getSession();
        session.setAttribute("LogonContext", (Object)logonContext);
        if (message != null) {
            req.setAttribute(ERROR_MSG_STR_ATTR, (Object)message);
        }
        try {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (IOException e) {
            log.error((Object)("Error sending redirect: " + e));
            throw new ServletException();
        }
    }
}

