/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.security.Principal;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidator;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataClientImpl;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTCancelRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SAML1Token;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSvrHandlerException;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxFilterToLogonAppIncoming;

public class FedSrvInitialRequestHandler {
    static final Logger log = Logger.getLogger(FedSrvInitialRequestHandler.class);

    public static boolean processInitalRequestData(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) throws ServletException {
        block39: {
            logonContext.setRpConfig(FedSrvConfig.getInstance().getDefaultRPConfig());
            try {
                PageRedirector pageRedirector;
                WSFedData wsfData = WSFedHelper.getWSFDataFromRequestParameters((HttpServletRequest)req);
                if (wsfData == null) {
                    String errorMessage = "FedSrvInitialRequestHandler.LogonContext. Error creating extracting WS-Federation parameters from HTTP request";
                    log.error((Object)errorMessage);
                    PageRedirector pageRedirector2 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector2.redirectAppError(req, resp, "Malformed or invalid request data");
                    return false;
                }
                if (wsfData.isEmpty()) {
                    log.error((Object)"HTTP requests is missing WS-Federation PRP parameters");
                    PageRedirector pageRedirector3 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector3.redrectDirectFobidden(req, resp);
                    return false;
                }
                WSFedDataValidator wsfFedDataValidator = WSFedDataObjectFactory.createWSFedDataValidator();
                ExtendedResult wsfValidationResult = wsfFedDataValidator.validateRequest(wsfData);
                if (!wsfValidationResult.isSuccess()) {
                    log.error((Object)("WS-Federation request profile validation failed: " + wsfValidationResult.getMessage()));
                    PageRedirector pageRedirector4 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector4.redirectAppError(req, resp, "Invalid request");
                    return false;
                }
                if (WSFedHelper.isRequestDataRemoted((WSFedData)wsfData) && !FedSrvInitialRequestHandler.retrieveRemoteData(req, resp, wsfData, logonContext)) {
                    return false;
                }
                logonContext.setInboundWsfData(wsfData);
                if (StringHelper.isNotBlank((String)wsfData.getWtrealm())) {
                    String rpuriString = wsfData.getWtrealm();
                    RPURI rpuri = RPURI.createRPURI((String)rpuriString);
                    if (rpuri == null) {
                        log.error((Object)("Invalid federation request: applies to uri does not conform to ALF SSO format: \"" + rpuriString + "\""));
                        PageRedirector pageRedirector5 = new PageRedirector(logonContext.getRpConfig());
                        pageRedirector5.redirectAppError(req, resp, "Invalid federation request: invalid relying party URI");
                        return false;
                    }
                    logonContext.setAppliesToURI(rpuriString);
                    FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuriString);
                    if (rpConfig == null) {
                        log.error((Object)("Failed to find matching configuration for relying party request: \"" + rpuriString + "\""));
                        PageRedirector pageRedirector6 = new PageRedirector(logonContext.getRpConfig());
                        pageRedirector6.redirectAppError(req, resp, "Failed to find matching configuration for relying party URI: \"" + rpuriString + "\"");
                        return false;
                    }
                    logonContext.setRpConfig(rpConfig);
                    if (StringHelper.isBlank((String)wsfData.getWreq())) {
                        if (wsfData.isSigninAction()) {
                            long requestTokenTTL = logonContext.getRpConfig().getCoreConfig().getLongParameter("SecurityTokenTTL", 28800L);
                            RSTIssueRequest issueRequest = new RSTIssueRequest();
                            issueRequest.setAppliesTo(rpuriString);
                            issueRequest.setTtl(requestTokenTTL);
                            wsfData.setWreq(issueRequest.toOM().toString());
                        } else {
                            if (wsfData.isSignoutAction()) {
                                FedSrvHelper.extractSSOTokenFromCookies(req, resp, logonContext);
                                if (logonContext.getCookieData() != null && logonContext.getCookieData().getToken() != null && !logonContext.getCookieData().getToken().isExpired()) {
                                    SSOToken cancelSSOTokenTarget = logonContext.getCookieData().getToken();
                                    SAML1Token cancelTarget = WSAbstractFactory.getWSSEObjectFactory().createSAML1Token(cancelSSOTokenTarget.getNativeObject());
                                    RSTCancelRequest cancelReqest = new RSTCancelRequest();
                                    cancelReqest.setSecurityToken((SignedSecurityToken)cancelTarget);
                                    cancelReqest.setEpr(rpuriString);
                                    logonContext.setWSTVersion(WSTrustVersion.V1);
                                    logonContext.setRSTObject(cancelReqest.toRequestSecurityToken());
                                    logonContext.setRSTElement(cancelReqest.toRequestSecurityToken().toOM());
                                    return true;
                                }
                                return true;
                            }
                            log.error((Object)("Unsupported WS-Federation action: \"" + wsfData.getWa() + "\""));
                            PageRedirector pageRedirector7 = new PageRedirector(logonContext.getRpConfig());
                            pageRedirector7.redirectAppError(req, resp, "Unsupported WS-Federation action: " + wsfData.getWa());
                            return false;
                        }
                    }
                }
                String payloadString = wsfData.getWreq();
                OMElement payloadElement = null;
                if (StringHelper.isBlank((String)payloadString)) {
                    log.error((Object)"FedSrvInitialRequestHandler.LogonContext. Missing request data: empty wreq");
                    pageRedirector = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector.redirectAppError(req, resp, "Malformed WS-Federation request");
                    return false;
                }
                try {
                    payloadElement = XMLHelper.toOM((String)payloadString);
                }
                catch (Throwable e) {
                    log.error((Object)("FedSrvInitialRequestHandler.LogonContext. Error trying to build an OM element from wreq: [" + payloadString + "]"), e);
                    PageRedirector pageRedirector8 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector8.redirectAppError(req, resp, "Invalid WS-Federation request data");
                    return false;
                }
                if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
                    payloadElement = FedSrvInitialRequestHandler.extractRSTFromSOAP(req, resp, payloadString, logonContext);
                }
                if (!SSOHelper.isRSTElement((OMElement)payloadElement)) {
                    log.error((Object)("Missing RST in wreq: [" + payloadString + "]"));
                    pageRedirector = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector.redirectAppError(req, resp, "Invalid WS-Federation request data");
                    return false;
                }
                RequestSecurityToken rst = FedSrvInitialRequestHandler.extractRequestSecurityTokenFromPayload(req, resp, payloadElement, logonContext);
                if (rst == null) {
                    return false;
                }
                if (!rst.getRequestType().isKnownRequestType()) {
                    String errorMessage = "Unknown RST request type: " + rst.getRequestType().getRequestType();
                    log.error((Object)errorMessage);
                    PageRedirector pageRedirector9 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector9.redirectAppError(req, resp, "Invalid request - unknown request type");
                    return false;
                }
                if (!rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getIssue()) && !rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    String errorMessage = "Unsupported RST request type: " + rst.getRequestType().getRequestType();
                    log.error((Object)errorMessage);
                    PageRedirector pageRedirector10 = new PageRedirector(logonContext.getRpConfig());
                    pageRedirector10.redirectAppError(req, resp, "Invalid request - unsupported request type");
                    return false;
                }
                String rstAppliesTo = FedSrvInitialRequestHandler.extractAppliesToFromRST(req, resp, rst, logonContext);
                if (StringHelper.isNotBlank((String)rstAppliesTo)) {
                    RPURI rpuri = RPURI.createRPURI((String)rstAppliesTo);
                    if (rpuri == null) {
                        String errorMessage = "RST/AppliesTo contains invalid RPURI: " + rstAppliesTo;
                        log.error((Object)errorMessage);
                        PageRedirector pageRedirector11 = new PageRedirector(logonContext.getRpConfig());
                        pageRedirector11.redirectAppError(req, resp, "Invalid request - invalid relying party URI");
                        return false;
                    }
                    FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                    if (rpConfig == null) {
                        String errorMessage = "Cannot find configuration for relying party URI: " + rpuri;
                        log.error((Object)errorMessage);
                        PageRedirector pageRedirector12 = new PageRedirector(logonContext.getRpConfig());
                        pageRedirector12.redirectAppError(req, resp, "Cannot find configuration for relying party URI: " + rpuri);
                        return false;
                    }
                    logonContext.setAppliesToURI(rstAppliesTo);
                    logonContext.setRpConfig(rpConfig);
                }
                logonContext.setRSTObject(rst);
                logonContext.setRSTElement(rst.toOM());
                if (rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    SSOToken cancelTarget = null;
                    try {
                        cancelTarget = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                    }
                    catch (SSOException e) {
                        log.error((Object)("Error processing request: could not extract cancel target: [" + payloadString + "]"));
                        PageRedirector pageRedirector13 = new PageRedirector(logonContext.getRpConfig());
                        pageRedirector13.redirectAppError(req, resp, "Error processing request: could not extract cancel target");
                        return false;
                    }
                    logonContext.setCancelTarget(cancelTarget);
                    String[] appliesToRelyingParties = cancelTarget.getTargetRelyingParties();
                    if (appliesToRelyingParties != null && appliesToRelyingParties.length > 0) {
                        String rpuriString = appliesToRelyingParties[0];
                        if (StringHelper.isBlank((String)rpuriString)) {
                            log.error((Object)("Error processing request: invalid cancel target: no audience restriction: [" + payloadString + "]"));
                            PageRedirector pageRedirector14 = new PageRedirector(logonContext.getRpConfig());
                            pageRedirector14.redirectAppError(req, resp, "Error processing request: invalid cancel target");
                            return false;
                        }
                        RPURI rpuri = RPURI.createRPURI((String)rpuriString);
                        if (rpuri == null) {
                            log.error((Object)("Error processing request: invalid cancel target: non-compatible RPURI: [" + payloadString + "]"));
                            PageRedirector pageRedirector15 = new PageRedirector(logonContext.getRpConfig());
                            pageRedirector15.redirectAppError(req, resp, "Error processing request: invalid cancel target");
                            return false;
                        }
                        logonContext.setAppliesToURI(rpuriString);
                        FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                        if (rpConfig == null) {
                            log.error((Object)("Error processing request: failed to find matching configuration context: [" + rpuriString + "]"));
                            PageRedirector pageRedirector16 = new PageRedirector(logonContext.getRpConfig());
                            pageRedirector16.redirectAppError(req, resp, "Error processing request: unknown relying party");
                            return false;
                        }
                        logonContext.setRpConfig(rpConfig);
                    }
                    break block39;
                }
                UsernameToken rstUsernameToken = FedSrvInitialRequestHandler.extractUsernameTokenFromRSTOnBehalfOfElement(req, resp, rst, payloadElement, logonContext);
                if (rstUsernameToken != null) {
                    boolean forceLocalAuthnPrompt = logonContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceLocalAuthentication", false);
                    if (forceLocalAuthnPrompt) {
                        rst.setOnBehalfOf(null);
                        logonContext.setPrincipalCredentialsAquired(false);
                    } else {
                        logonContext.setPrincipalUsername(rstUsernameToken.getUsername());
                        logonContext.setPrincipalPassword(null);
                        logonContext.setPrincipalCredentialsAquired(true);
                        logonContext.setAuthCredentialsInRST(true);
                    }
                } else {
                    Principal principal = req.getUserPrincipal();
                    if (principal != null) {
                        boolean useExistingPrincipal = logonContext.getRpConfig().getCoreConfig().getBooleanParameter("UsePrincipalUserIfPresent", false);
                        boolean isAllowedAuthnType = logonContext.getRpConfig().getCoreConfig().isAllowedPreauthenticationType(req.getAuthType());
                        if (useExistingPrincipal && isAllowedAuthnType) {
                            log.debug((Object)("Using principal user: " + principal.getName() + "/" + req.getAuthType()));
                            FedSrvInitialRequestHandler.addPrincipalToRSTWithinOnBehalfOfElement(req, resp, principal.getName(), rst, payloadElement);
                            logonContext.setPrincipalUsername(principal.getName());
                            logonContext.setPrincipalPassword(null);
                            logonContext.setPrincipalCredentialsAquired(true);
                            logonContext.setAuthCredentialsInRST(true);
                        } else {
                            log.warn((Object)("FedSrvInitialRequestHandler.LogonContext. Principal user is found on the request but authentication type is not allowed:" + principal.getName() + "/" + req.getAuthType()));
                        }
                    }
                }
            }
            catch (FedSvrHandlerException e) {
                log.error((Object)"FedSvrHandler Exception", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean retrieveRemoteData(HttpServletRequest req, HttpServletResponse resp, WSFedData wsfData, LogonContext logonContext) throws ServletException {
        try {
            RemoteDataClientImpl remoteContentClient = new RemoteDataClientImpl();
            String remoteContentURL = wsfData.getWreqptr();
            String remoteContent = remoteContentClient.getRemoteContent(remoteContentURL, null);
            log.debug((Object)("remoteContentURL = " + remoteContentURL + " remoteContent" + remoteContent));
            if (remoteContent == null || remoteContent.trim().length() == 0) {
                log.error((Object)"Empty remote content returned");
                PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
                pageRedirector.redirectAppError(req, resp, "Unable to get remote request data from " + wsfData.getWreqptr());
                return false;
            }
            wsfData.setWreq(remoteContent);
            wsfData.setWreqptr(null);
        }
        catch (Throwable e) {
            log.error((Object)"Retrieving remote data", e);
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, "Error aquiring request data from " + wsfData.getWreqptr());
            return false;
        }
        return true;
    }

    private static OMElement extractRSTFromSOAP(HttpServletRequest req, HttpServletResponse resp, String payloadString, LogonContext logonContext) throws FedSvrHandlerException, ServletException {
        SOAPEnvelope payloadElement = null;
        try {
            payloadElement = SOAPHelper.buildSOAPElement((String)payloadString);
        }
        catch (Throwable e) {
            log.error((Object)("Error trying to build a SOAP element from wreq: [" + payloadString + "]"), e);
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, "Invalid wreq: [" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        log.debug((Object)"Received SOAP message containing RST element");
        CoreConfig rpCoreConfig = logonContext.getRpConfig().getCoreConfig();
        try {
            RSTDeserializer soapDeserializer = new RSTDeserializer(rpCoreConfig.getAxis2ConfigurationContextReceiver());
            SecCtxFilterToLogonAppIncoming securityContext = new SecCtxFilterToLogonAppIncoming();
            soapDeserializer.setSecurityContext((SecurityContext)securityContext);
            payloadElement = soapDeserializer.receiveSOAPMessage(payloadElement.toString());
        }
        catch (SSOException e) {
            log.error((Object)"Error deserializing soap message", (Throwable)e);
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, "Error deserializing SOAP message:[" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        catch (AxisFault e) {
            log.error((Object)"Axis fault", (Throwable)e);
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, "Error sending/receiving SOAP message locally:[" + payloadString + "]");
            throw new FedSvrHandlerException();
        }
        return payloadElement;
    }

    private static RequestSecurityToken extractRequestSecurityTokenFromPayload(HttpServletRequest req, HttpServletResponse resp, OMElement payloadElement, LogonContext logonContext) throws FedSvrHandlerException, ServletException {
        RequestSecurityToken rst = null;
        try {
            rst = WSTrustObjectBuilder.buildRequestSecurityToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            log.error((Object)("Error deserializing RST element: [" + payloadElement.toString() + "]"));
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, "Error deserializing RST element from wreq: [" + payloadElement.toString() + "]");
            return null;
        }
        return rst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UsernameToken extractUsernameTokenFromRSTOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, OMElement payloadElement, LogonContext logonContext) throws FedSvrHandlerException, ServletException {
        UsernameToken onBehalfOfUsernameToken = null;
        if (rst.getOnBehalfOf() == null) return onBehalfOfUsernameToken;
        if (rst.getOnBehalfOf().getSecurityToken() != null) {
            if (rst.getOnBehalfOf().getSecurityToken().getType().equals("UsernameToken")) {
                onBehalfOfUsernameToken = (UsernameToken)rst.getOnBehalfOf().getSecurityToken().getNativeObject();
                if (onBehalfOfUsernameToken.getUsername() != null && onBehalfOfUsernameToken.getUsername().trim().length() != 0) return onBehalfOfUsernameToken;
                String errMsg = "Unsuppored RST - incompatible profile - missing <Username>: [" + payloadElement.toString() + "]";
                log.error((Object)errMsg);
                PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
                pageRedirector.redirectAppError(req, resp, errMsg);
                throw new FedSvrHandlerException();
            }
            String errMsg = "Unsuppored RST - incompatible profile - incompatible token: [" + payloadElement.toString() + "]";
            log.error((Object)errMsg);
            PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
            pageRedirector.redirectAppError(req, resp, errMsg);
            throw new FedSvrHandlerException();
        }
        String errMsg = "Unsuppored RST - incompatible profile - missing <UsernameToken>: [" + payloadElement.toString() + "]";
        log.error((Object)errMsg);
        PageRedirector pageRedirector = new PageRedirector(logonContext.getRpConfig());
        pageRedirector.redirectAppError(req, resp, errMsg);
        throw new FedSvrHandlerException();
    }

    private static RequestSecurityToken addPrincipalToRSTWithinOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, String principal, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        OnBehalfOf onBehalfOf = rst.getWSTrust().getObjectFactory().createOnBehalfOf();
        UsernameToken usernameToken = WSAbstractFactory.getWSSEObjectFactory().createUsernameToken();
        usernameToken.addId();
        usernameToken.addCreated();
        usernameToken.setUsername(principal);
        onBehalfOf.setSecurityToken((SecurityToken)usernameToken);
        rst.setOnBehalfOf(onBehalfOf);
        return rst;
    }

    private static String extractAppliesToFromRST(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, LogonContext logonContext) throws FedSvrHandlerException, ServletException {
        if (rst.getAppliesTo() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList().size() == 0) {
            return null;
        }
        Iterator it = rst.getAppliesTo().getKnownObjectsList().iterator();
        if (it != null) {
            while (it.hasNext()) {
                EndpointReference epr;
                Object obj = it.next();
                if (!(obj instanceof EndpointReference) || (epr = (EndpointReference)obj).getAddress() == null || epr.getAddress().getAddress() == null) continue;
                return epr.getAddress().getAddress();
            }
        }
        return null;
    }
}

