/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvCancelRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvInitialRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.handler.RemoteDataRequestHandler;
import org.eclipse.alf.security.sso.server.federationserver.processor.IssueRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;

public class FedSrvRequestHandler {
    private static final Logger log = Logger.getLogger(FedSrvRequestHandler.class);

    public static void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        RemoteDataRequestHandler remoteDataRequestHandler;
        LogonContext logonContext = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering the main request handler");
        }
        if ((remoteDataRequestHandler = new RemoteDataRequestHandler()).isValidRemoteDataRequest(req)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Serving remote data request");
            }
            remoteDataRequestHandler.serveRequest(req, resp);
            return;
        }
        HttpSession httpSession = req.getSession();
        LogonContext sessionLogonContext = (LogonContext)httpSession.getAttribute("LogonContext");
        if (sessionLogonContext != null) {
            logonContext = sessionLogonContext;
            httpSession.removeAttribute("LogonContext");
        } else {
            logonContext = new LogonContext();
        }
        if (sessionLogonContext == null) {
            RequestSecurityToken rstObj;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handling ws-federation intial request");
            }
            if (!FedSrvInitialRequestHandler.processInitalRequestData(req, resp, logonContext)) {
                return;
            }
            if (!logonContext.getCookieTokenQueried()) {
                FedSrvHelper.extractSSOTokenFromCookies(req, resp, logonContext);
            }
            if ((rstObj = logonContext.getRSTObject()).getRequestType().getRequestType().equals(rstObj.getWSTrust().RequestTypes.getCancel())) {
                log.info((Object)("Processing a RST/Cancel request for " + logonContext.getAppliesToURI()));
                FedSrvCancelRequestHandler.handleCancelRequest(req, resp, logonContext);
                return;
            }
            if (!logonContext.getPrincipalCredentialsAquired()) {
                boolean redirectToLoginPage = true;
                if (logonContext.getCookieData() != null && logonContext.getCookieData().getToken() != null) {
                    SSOToken cookieToken = logonContext.getCookieData().getToken();
                    if (cookieToken.isExpired()) {
                        logonContext.setPrincipalUsername(cookieToken.getSubjectName());
                    } else {
                        redirectToLoginPage = false;
                    }
                }
                if (redirectToLoginPage) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Not sufficcient credentials found on the request, redirecting to login page");
                    }
                    PageRedirector redirector = new PageRedirector(logonContext.getRpConfig());
                    redirector.redirectToLoginPage(req, resp, logonContext, null);
                    return;
                }
            }
        } else {
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            if (StringHelper.isBlank((String)username)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Username from login form is empty, redirecting back to login page");
                }
                PageRedirector redirector = new PageRedirector(logonContext.getRpConfig());
                redirector.redirectToLoginPage(req, resp, logonContext, "Username cannot be empty");
                return;
            }
            logonContext.setPrincipalUsername(username.trim());
            logonContext.setPrincipalPassword(password.trim());
            logonContext.setPrincipalCredentialsAquired(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Process RST/Issue request");
        }
        IssueRequestProcessor issueProcessor = new IssueRequestProcessor();
        PageRedirector redirector = new PageRedirector(logonContext.getRpConfig());
        RequestProcessorResult result = null;
        try {
            result = issueProcessor.process(req, resp, logonContext);
        }
        catch (ProcessingException e) {
            log.error((Object)("Error processing issue request: " + e.getMessage()));
            redirector.redirectAppError(req, resp, "Error processing issue request: " + e.getLocalizedMessage());
            return;
        }
        if (!result.isSuccess()) {
            log.error((Object)("Error processing issue request: " + result.getMessage()));
            redirector.redirectAppError(req, resp, "Error aquiring secuity token: " + result.getMessage());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully issued a token. Redirecting back to the relying party");
        }
        redirector.redrectBack(req, resp, logonContext.getOutboundWsfData(), logonContext.getUsedLoginForm());
    }
}

