/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.processor;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.PrincipalEndorsmentConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.http.cookie.MasterCookieData;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.EscapeCharHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataObjectFactory;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTCallProxy;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.message.trust.RSTRequest;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTIssueRequest;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.ProcessingException;
import org.eclipse.alf.security.sso.server.federationserver.processor.AbstractRequestProcessor;
import org.eclipse.alf.security.sso.server.federationserver.processor.RequestProcessorResult;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTS;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxLogonAppToSTSWithUsername;

public class IssueRequestProcessor
extends AbstractRequestProcessor {
    private static final Logger log = Logger.getLogger(IssueRequestProcessor.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RequestProcessorResult process(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) throws ProcessingException {
        WSFedData outboundWSFedData = WSFedDataObjectFactory.createWSFedData();
        outboundWSFedData.copyDeep(logonContext.getInboundWsfData());
        RequestProcessorResult retVal = new RequestProcessorResult();
        Object rstr = null;
        if (logonContext.getCookieData() != null && logonContext.getCookieData().getToken() != null && logonContext.getCookieData().getToken().validateToken().isSuccess()) {
            SSOToken ssoToken = logonContext.getCookieData().getToken();
            WSTrustObjectFactory fac = WSAbstractFactory.getWSTObjectFactory();
            rstr = fac.createRequestSecurityTokenResponse();
            rstr.setTokenType(fac.createTokenType("urn:oasis:names:tc:SAML:1.0:assertion#Assertion"));
            rstr.setLifetime(fac.createLifetime(ssoToken.getNotBefore(), ssoToken.getNotOnOrAfter()));
            RequestedSecurityToken requestedSecurityToken = fac.createRequestedSecurityToken();
            requestedSecurityToken.setSecurityToken((SecurityToken)ssoToken.toSecurityToken());
            rstr.setRequestedSecurityToken(requestedSecurityToken);
        }
        if (rstr == null) {
            RSTCallProxy callProxy = null;
            try {
                callProxy = new RSTCallProxy(logonContext.getRpConfig().getCoreConfig().getAxis2ConfigurationContext());
            }
            catch (SSOException e) {
                // empty catch block
            }
            if (callProxy == null) {
                retVal.setCode(2);
                retVal.setMessage("Failed to create SOAP call proxy");
                return retVal;
            }
            RSTIssueRequest request = new RSTIssueRequest();
            request.setSSOTokenType("http://www.eclipse.org/ALF/1.0/claims/TicketType#TGT");
            request.setEpr(logonContext.getRpConfig().getCoreConfig().getParameter("SecurityTokenService"));
            request.setRawRST(logonContext.getRSTElement());
            try {
                SecurityContext securityContext;
                if (logonContext.getAuthCredentialsInRST()) {
                    if (logonContext.getPrincipalPassword() != null) {
                        log.debug((Object)"Token issueance: Full principal credentials in RST");
                        securityContext = new SecCtxLogonAppToSTS();
                        request.setSecurityContext(securityContext);
                        log.debug((Object)"====> Before sending WS-Trust RST to STS. Full authentication credentials are with the RST.");
                        rstr = callProxy.invoke((RSTRequest)request);
                        log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
                    } else {
                        log.debug((Object)"Token issueance: partial principal credentials in RST");
                        PrincipalEndorsmentConfig endorsmentConfig = logonContext.getRpConfig().getCoreConfig().getPrincipalEndorsmentConfig();
                        if (endorsmentConfig == null) throw new SSOException("Incomplete credentials and endorsment method has not been properly set");
                        if (endorsmentConfig.getType() == 1) {
                            if (StringHelper.isBlank((String)endorsmentConfig.getUsername())) {
                                log.error((Object)"Undefined endorsing user when endorsing method is set to UsernameToken");
                                retVal.setCode(4);
                                retVal.setMessage("Insufficent endorsing credentials");
                                return retVal;
                            }
                            securityContext = new SecCtxLogonAppToSTSWithUsername();
                            securityContext.setOfcUsername(endorsmentConfig.getUsername());
                            securityContext.setOfcPassword(endorsmentConfig.getPassword());
                        } else {
                            if (endorsmentConfig.getType() != 2) throw new SSOException("Incomplete credentials and endorsment method has not been properly set");
                            securityContext = new SecCtxLogonAppToSTS();
                        }
                        request.setSecurityContext(securityContext);
                        log.debug((Object)"====> Before sending WS-Trust RST to STS - NTLM or similar flavor.");
                        rstr = callProxy.invoke((RSTRequest)request);
                        log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
                    }
                } else {
                    log.debug((Object)"Case is: Full authentication credentials supplied by logon page.");
                    securityContext = new SecCtxLogonAppToSTSWithUsername();
                    securityContext.setOfcUsername(logonContext.getPrincipalUsername());
                    securityContext.setOfcPassword(logonContext.getPrincipalPassword());
                    request.setSecurityContext(securityContext);
                    log.debug((Object)"====> Before sending WS-Trust RST to STS using credentials from logon page.");
                    rstr = callProxy.invoke((RSTRequest)request);
                    log.debug((Object)"<==== After receiving WS-Trust RSTR or Fault back from STS.");
                }
            }
            catch (AxisFault e) {
                log.error((Object)"Axis fault caught while issuing a SOAP call to STS.", (Throwable)e);
                retVal.setCode(1);
                retVal.setMessage(e.getMessage() + " : " + e.getDetail());
                return retVal;
            }
            catch (SSOException e) {
                log.error((Object)"SSO exception while issuing a SOAP call to STS.", (Throwable)e);
                retVal.setCode(2);
                retVal.setMessage(e.getMessage());
                return retVal;
            }
        }
        String wresult = rstr.toString();
        outboundWSFedData.setWresult(wresult);
        if (log.isDebugEnabled()) {
            log.debug((Object)("wresult = " + wresult));
        }
        SSOToken issuedToken = null;
        try {
            CookieManager cookieManager = logonContext.getRpConfig().getCoreConfig().getCookieManager();
            String remoteUserIP = cookieManager.getBindCookiesToUserIP() ? req.getRemoteAddr() : null;
            issuedToken = SSOTokenFactory.createSSOToken((SecurityToken)rstr.getRequestedSecurityToken().getSecurityToken());
            MasterCookieData masterCookieData = new MasterCookieData(logonContext.getAppliesToURI(), issuedToken, remoteUserIP);
            ArrayList cookies = cookieManager.createCookie((CookieData)masterCookieData);
            CookieHTTPHelper.addCokiesToResponse((HttpServletResponse)resp, (ArrayList)cookies);
        }
        catch (SSOException e) {
            log.error((Object)"Error creating master cookie");
            retVal.setCode(2);
            retVal.setMessage(e.getMessage());
            return retVal;
        }
        logonContext.setIssuedToken(issuedToken);
        boolean forceRemoteData = logonContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceRemoteDataInWSFederation", false);
        if (forceRemoteData) {
            long remoteDataTTL = logonContext.getRpConfig().getCoreConfig().getLongParameter("RemoteDataTTL", 60L);
            String remoteDataURI = logonContext.getRpConfig().getCoreConfig().getParameter("RemoteDataServerEPR", "");
            RemoteDataStorage rd = RemoteDataStorage.getInstance();
            String rdKey = rd.addData((Object)outboundWSFedData.getWresult(), remoteDataTTL);
            String remoteDataURL = req.getRequestURL().toString();
            if (StringHelper.isNotBlank((String)remoteDataURI)) {
                if (remoteDataURI.charAt(0) != '/') {
                    remoteDataURI = remoteDataURI + "/" + remoteDataURI;
                }
                String requestURL = req.getRequestURL().toString();
                String requestURI = req.getRequestURI();
                if (requestURI.substring(1).indexOf(47) > 0) {
                    int to = requestURI.substring(1).indexOf(47);
                    String appname = requestURI.substring(0, to + 1);
                    remoteDataURI = appname + remoteDataURI;
                } else {
                    String appname = requestURI;
                    remoteDataURI = appname + remoteDataURI;
                }
                remoteDataURL = StringHelper.simpleStringReplace((String)requestURL, (String)requestURI, (String)remoteDataURI);
            }
            remoteDataURL = logonContext.getRpConfig().getCoreConfig().getRemoteDataURL(remoteDataURL, req.getServerPort());
            outboundWSFedData = WSFedHelper.convertWresultToWresultptr((String)remoteDataURL, (String)rdKey, (WSFedData)outboundWSFedData);
        } else {
            outboundWSFedData.setWresult(EscapeCharHelper.forHTMLTag((String)outboundWSFedData.getWresult()));
        }
        logonContext.setOutboundWsfData(outboundWSFedData);
        return retVal;
    }
}

