/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieHTTPHelper;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.token.SSOTokenPolicy;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Address;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.LogonContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;

public class FedSrvHelper {
    private static final Logger log = Logger.getLogger(FedSrvHelper.class);

    public static CookieData extractALFSSOCookieData(HttpServletRequest req, FedSrvRPConfig rpConfig, String rpType, String rpRealm, ArrayList cookieObjects) {
        CookieData cookieData = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cookies were found.");
            }
            String remoteUserIP = req.getRemoteAddr();
            try {
                cookieData = rpConfig.getCoreConfig().getCookieManager().getBindCookiesToUserIP() ? rpConfig.getCoreConfig().getCookieManager().getCookie(cookies, rpType, rpRealm, remoteUserIP, cookieObjects) : rpConfig.getCoreConfig().getCookieManager().getCookie(cookies, rpType, rpRealm, null, cookieObjects);
            }
            catch (SSOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error while finding cookie for:" + rpType + ":" + rpRealm));
                }
                return null;
            }
        }
        if (cookieData != null) {
            SSOToken token = cookieData.getToken();
            SAML1Policy tokenProfilePolicy = rpConfig.getTokenPolicy();
            token.setValidationPolicy((SSOTokenPolicy)tokenProfilePolicy);
        }
        return cookieData;
    }

    public static SSOToken extractTokenFromHTTPHeader(HttpServletRequest req, LogonContext logonContext) {
        SSOToken token;
        block6: {
            String tokenString = null;
            token = null;
            if (req.getHeader("ALFSSOAuthNToken") != null) {
                tokenString = req.getHeader("ALFSSOAuthNToken");
            }
            if (StringHelper.isNotBlank(tokenString)) {
                tokenString = tokenString.trim();
                try {
                    token = SSOTokenFactory.createSSOToken((String)tokenString);
                    if (token == null) {
                        log.debug((Object)"Error creating SSO token object from header content");
                        break block6;
                    }
                    token.setValidationPolicy((SSOTokenPolicy)logonContext.getRpConfig().getTokenPolicy());
                }
                catch (SSOException e) {
                    log.info((Object)"Error processing security token", (Throwable)e);
                }
            } else {
                log.warn((Object)"ALF SSO header found on request but no content in it");
            }
        }
        return token;
    }

    public static String extractAppliesToStringFromRST(RequestSecurityToken rst) {
        String retVal = null;
        if (rst == null) {
            return null;
        }
        AppliesTo appliesToObj = rst.getAppliesTo();
        if (appliesToObj != null) {
            List knownObjList = appliesToObj.getKnownObjectsList();
            if (knownObjList != null && knownObjList.size() == 1) {
                EndpointReference eprObj = null;
                Address addr = null;
                if (knownObjList.get(0) instanceof EndpointReference) {
                    eprObj = (EndpointReference)knownObjList.get(0);
                    if (eprObj != null) {
                        addr = eprObj.getAddress();
                    }
                } else if (knownObjList.get(0) instanceof Address) {
                    addr = (Address)knownObjList.get(0);
                }
                if (addr != null) {
                    retVal = addr.getAddress();
                }
            }
        } else if (rst.getCancelTarget() != null && rst.getCancelTarget().getSecurityToken() != null) {
            try {
                SSOToken token = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                String[] tokenTargetRelyingParties = token.getTargetRelyingParties();
                retVal = tokenTargetRelyingParties.length == 0 ? null : tokenTargetRelyingParties[0];
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean extractSSOTokenFromCookies(HttpServletRequest req, HttpServletResponse resp, LogonContext logonContext) {
        if (logonContext == null) {
            return false;
        }
        if (StringHelper.isBlank((String)logonContext.getAppliesToURI())) {
            return false;
        }
        RPURI rpuri = RPURI.createRPURI((String)logonContext.getAppliesToURI());
        if (rpuri == null) {
            return false;
        }
        ArrayList cookiesToClear = new ArrayList();
        CookieData cookieData = FedSrvHelper.extractALFSSOCookieData(req, logonContext.getRpConfig(), rpuri.getType(), rpuri.getRealm(), cookiesToClear);
        if (cookieData != null) {
            logonContext.setCookieData(null);
            SSOToken token = cookieData.getToken();
            SAML1Policy rpTokenPolicy = logonContext.getRpConfig().getTokenPolicy();
            token.setValidationPolicy((SSOTokenPolicy)rpTokenPolicy);
            ExtendedResult validationResult = token.validateToken();
            if (validationResult.isSuccess()) {
                logonContext.setCookieData(cookieData);
            } else {
                if (validationResult.getCode() == 10) {
                    logonContext.setCookieData(cookieData);
                }
                CookieHTTPHelper.deleteCookies((HttpServletResponse)resp, cookiesToClear);
            }
        }
        logonContext.setCookieTokenQueried(true);
        return true;
    }
}

