/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfigLoader;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSrvRequestHandler;

public class FedSrvServlet
extends HttpServlet {
    static final Logger log = Logger.getLogger(FedSrvServlet.class);
    private static final long serialVersionUID = -391484377137870342L;
    private ServletConfig servletConfig = null;
    private FedSrvConfigLoader configLoader = new FedSrvConfigLoader();

    public void init(ServletConfig servletConfig) throws ServletException {
        this.configLoader = new FedSrvConfigLoader();
        this.servletConfig = servletConfig;
    }

    private void doProcess(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        block5: {
            try {
                if (!this.configLoader.isConfigurationLoaded()) {
                    this.configLoader.loadConfiguration(this.servletConfig);
                }
            }
            catch (Throwable e) {
                log.fatal((Object)"Failed to load configuration settings");
                throw new ServletException("Failed to load configuration settings", e);
            }
            try {
                FedSrvRequestHandler.processRequest(req, resp);
            }
            catch (Throwable e) {
                log.error((Object)"Unhandled exception in FedSrv servlet", e);
                if (!resp.isCommitted()) break block5;
                throw new ServletException("Error in federation server", e);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"FedSrvServlet.doGet(): Handling a GET request");
        }
        this.doProcess(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"FedSrvServlet.doPost  Handling a POST request");
        }
        this.doProcess(req, resp);
    }
}

