/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.config;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.util.FileIOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.builder.FedSrvConfigBuilder;
import org.opensaml.SAMLConfig;

public class FedSrvConfigLoader {
    private static final Logger log = Logger.getLogger(FedSrvConfigLoader.class);
    private boolean configrationLoaded = false;

    public synchronized boolean isConfigurationLoaded() {
        return this.configrationLoaded;
    }

    public synchronized void loadConfiguration(ServletConfig servletConfig) throws ServletException {
        if (this.configrationLoaded) {
            return;
        }
        try {
            File ssoConfigNameFile;
            boolean ssoConfigFileFound;
            Init.init();
            SAMLConfig.instance();
            String servletBasePath = FileIOHelper.normalizePath((String)(servletConfig.getServletContext().getRealPath("") + "/"));
            if (StringHelper.isBlank((String)servletBasePath)) {
                log.warn((Object)"ServletConfig.getServletContext().getRealPath() failed to return the real path. Trying servlet init params");
                servletBasePath = servletConfig.getServletContext().getInitParameter("ROOT_PATH");
            }
            if (StringHelper.isBlank((String)servletBasePath)) {
                log.fatal((Object)"Failed to resolve root real path - neither the servlet container returned it or the context params have it");
                throw new ServletException("Failed to resolve servlet real path");
            }
            File filterBasePathFile = new File(servletBasePath);
            if (!filterBasePathFile.isDirectory()) {
                log.error((Object)("Filter root real path: \"" + servletBasePath + "\" does not exist"));
                throw new ServletException("Failed to resolve root path");
            }
            try {
                servletBasePath = FileIOHelper.normalizePath((String)filterBasePathFile.getCanonicalPath()) + "/";
            }
            catch (IOException e) {
                servletBasePath = FileIOHelper.normalizePath((String)filterBasePathFile.getAbsolutePath()) + "/";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Federation server: using filter base path: \"" + servletBasePath + "\""));
            }
            String ssoConfigName = System.getProperty("org.eclipse.alf.security.sso.server.fedsrv.conf-name");
            String ssoConfigDir = null;
            if (StringHelper.isBlank((String)ssoConfigName)) {
                ssoConfigName = servletConfig.getInitParameter("LogonUIConfigName");
            }
            if (StringHelper.isBlank((String)ssoConfigName)) {
                ssoConfigName = FileIOHelper.normalizePath((String)(servletBasePath + File.separatorChar + "/WEB-INF/conf" + File.separatorChar + "fedsvr-services-config.xml"));
            }
            if (!(ssoConfigFileFound = (ssoConfigNameFile = new File(ssoConfigName = FileIOHelper.normalizePath((String)ssoConfigName))).isFile())) {
                ssoConfigName = FileIOHelper.normalizePath((String)(servletBasePath + File.separatorChar + ssoConfigName));
                ssoConfigNameFile = new File(ssoConfigName);
                ssoConfigFileFound = ssoConfigNameFile.isFile();
            }
            if (!ssoConfigFileFound) {
                ssoConfigName = FileIOHelper.normalizePath((String)(servletBasePath + File.separatorChar + "/WEB-INF/conf" + File.separatorChar + ssoConfigName));
                ssoConfigNameFile = new File(ssoConfigName);
                ssoConfigFileFound = ssoConfigNameFile.isFile();
            }
            if (!ssoConfigFileFound) {
                String errorMessage = "Configuration file: \"" + ssoConfigName + "\" does not exist";
                log.error((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
            try {
                ssoConfigDir = FileIOHelper.normalizePath((String)(new File(ssoConfigNameFile.getParent()).getCanonicalPath() + "/"));
            }
            catch (IOException e) {
                ssoConfigDir = FileIOHelper.normalizePath((String)(new File(ssoConfigNameFile.getParent()).getAbsolutePath() + "/"));
            }
            ssoConfigName = ssoConfigNameFile.getName();
            FedSrvConfigBuilder configBuilder = new FedSrvConfigBuilder(ssoConfigDir);
            FedSrvConfig config = null;
            try {
                config = configBuilder.build(ssoConfigName);
            }
            catch (Exception e) {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Federation server: Failed to load configuration from \"" + fullpath + "\"";
                log.fatal((Object)errorMessage);
                throw new ServletException(errorMessage, (Throwable)e);
            }
            if (config == null) {
                String fullpath = FileIOHelper.normalizePath((String)(ssoConfigDir + "/" + ssoConfigName));
                String errorMessage = "Federation server: Failed to load configuration from \"" + fullpath + "\"";
                log.fatal((Object)errorMessage);
                throw new ServletException(errorMessage);
            }
            Iterator it = config.getRPConfigIterartor();
            if (it != null) {
                while (it.hasNext()) {
                    FedSrvRPConfig rpConfig = (FedSrvRPConfig)it.next();
                    CoreConfig coreConfig = rpConfig.getCoreConfig();
                    coreConfig.setProperty("ApplicationRootAbsolutePath", servletBasePath);
                    coreConfig.setProperty("ConfigBaseAbsolutePath", ssoConfigDir);
                    coreConfig.registerSubstitutionVariable("${APPROOT_DIR}", servletBasePath);
                    coreConfig.registerSubstitutionVariable("${CONFIG_DIR}", ssoConfigDir);
                    coreConfig.expandSubstitutionVariables();
                    coreConfig.setJSSEProperties();
                    coreConfig.initAxis2();
                }
                FedSrvConfig.setInstance(config);
                this.configrationLoaded = true;
            }
        }
        catch (Throwable e) {
            String errorMessage = "Error while trying to initialize ALF SSO federation server: " + e.getMessage();
            log.fatal((Object)errorMessage, e);
            throw new ServletException(errorMessage, e);
        }
    }
}

