/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class RPURIMatcher
extends AbstractMatcher {
    private static final Logger log = Logger.getLogger(RPURIMatcher.class);
    public static final String DEFAULT_REGEX_STRING = "*";
    public static final String DEFAULT_REGEX_STRING_JAVAREGEX = ".*";
    protected String regexType;
    protected String regexRealm;
    protected String regexInstance;
    protected Pattern regexTypePattern;
    protected Pattern regexRealmPattern;
    protected Pattern regexInstancePattern;

    public RPURIMatcher() {
        this.reset();
    }

    public RPURIMatcher(int matcherType) {
        super(matcherType);
        this.reset();
    }

    public RPURIMatcher(int matcherType, String regexType, String regexRealm, String regexInstance) throws SSOException {
        super(matcherType);
        this.reset();
        this.regexType = regexType;
        this.regexRealm = regexRealm;
        this.regexInstance = regexInstance;
        if (matcherType == 2) {
            try {
                this.regexTypePattern = Pattern.compile(regexType);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + regexType + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
            try {
                this.regexRealmPattern = Pattern.compile(regexRealm);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + regexRealm + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
            try {
                this.regexInstancePattern = Pattern.compile(regexInstance);
            }
            catch (PatternSyntaxException e) {
                String errorMessage = "Invalid regex pattern: \"" + regexInstance + "\"";
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage, e);
            }
        }
    }

    public void reset() {
        this.regexType = DEFAULT_REGEX_STRING;
        this.regexRealm = DEFAULT_REGEX_STRING;
        this.regexInstance = DEFAULT_REGEX_STRING;
        if (this.matcherType == 2) {
            try {
                this.regexTypePattern = Pattern.compile(this.regexType);
                this.regexRealmPattern = Pattern.compile(this.regexRealm);
                this.regexInstancePattern = Pattern.compile(this.regexInstance);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public boolean matches(String type, String realm, String instance) {
        if (this.matcherType == 2) {
            Matcher typeMatcher = this.regexTypePattern.matcher(type);
            Matcher realmMatcher = this.regexRealmPattern.matcher(realm);
            Matcher instanceMatcher = this.regexInstancePattern.matcher(instance);
            return typeMatcher != null && realmMatcher != null && instanceMatcher != null && typeMatcher.matches() && realmMatcher.matches() && instanceMatcher.matches();
        }
        return StringHelper.basicWildcardMatch(this.regexType, type) && StringHelper.basicWildcardMatch(this.regexRealm, realm) && StringHelper.basicWildcardMatch(this.regexInstance, instance);
    }

    public String getRegexType() {
        return this.regexType;
    }

    public void setRegexType(String regexType) throws SSOException {
        if (StringHelper.isBlank(regexType)) {
            this.regexType = DEFAULT_REGEX_STRING;
        }
        this.regexType = regexType;
        if (this.matcherType == 2) {
            try {
                this.regexTypePattern = Pattern.compile(regexType);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI type regex: " + regexType;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getRegexRealm() {
        return this.regexRealm;
    }

    public void setRegexRealm(String regexRealm) throws SSOException {
        if (StringHelper.isBlank(regexRealm)) {
            this.regexRealm = DEFAULT_REGEX_STRING;
        }
        this.regexRealm = regexRealm;
        if (this.matcherType == 2) {
            try {
                this.regexRealmPattern = Pattern.compile(regexRealm);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI realm regex: " + regexRealm;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String getRegexInstance() {
        return this.regexInstance;
    }

    public void setRegexInstance(String regexInstance) throws SSOException {
        if (StringHelper.isBlank(regexInstance)) {
            this.regexInstance = DEFAULT_REGEX_STRING;
        }
        this.regexInstance = regexInstance;
        if (this.matcherType == 2) {
            try {
                this.regexInstancePattern = Pattern.compile(regexInstance);
            }
            catch (PatternSyntaxException e) {
                String errorString = "Invalid pattern while trying to set RPURI instance regex: " + regexInstance;
                log.error((Object)errorString, (Throwable)e);
                throw new SSOException(errorString, e);
            }
        }
    }

    public String toString() {
        return RPURI.createRPURI(this.regexType, this.regexRealm, this.regexInstance).toString();
    }
}

