/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.matcher.builder;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.AbstractMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SOAPActionMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.builder.AbstractMatcherBuilder;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;

public class SOAPActionMatcherBuilder
extends AbstractMatcherBuilder {
    private static final Logger log = Logger.getLogger(SOAPActionMatcherBuilder.class);
    public static final String SOAP_ACTION_MATCHER_LN = "SOAPActionMatcher";
    public static final String ATTR_SOAP_ACTION_LN = "soapAction";

    public SOAPActionMatcherBuilder() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public String getLocalName() {
        return SOAP_ACTION_MATCHER_LN;
    }

    public AbstractMatcher build(OMElement element) throws SSOException {
        if (element == null) {
            return null;
        }
        if (!element.getLocalName().equals(this.getLocalName())) {
            return null;
        }
        String soapAction = XMLHelper.getAttribute(element, ATTR_SOAP_ACTION_LN);
        String comparer = XMLHelper.getAttribute(element, "comparer");
        SOAPActionMatcher retVal = StringHelper.isBlank(comparer) ? new SOAPActionMatcher(1) : (comparer.equals("basic") ? new SOAPActionMatcher(1) : (comparer.equals("regex") ? new SOAPActionMatcher(2) : new SOAPActionMatcher(1)));
        if (StringHelper.isBlank(soapAction)) {
            return null;
        }
        retVal.setSOAPActionRegex(soapAction);
        return retVal;
    }
}

