/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteDataStorage {
    static final Logger log = Logger.getLogger(RemoteDataStorage.class);
    private Map storage = new Hashtable();
    long lastUsedKey = 1L;

    private RemoteDataStorage() {
    }

    public static synchronized RemoteDataStorage getInstance() {
        return RemoteDataStorageHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addData(Object data, long ttl) {
        Long key;
        this.reap();
        if (data == null) {
            log.error((Object)"Invalid argument");
            throw new NullPointerException();
        }
        Date expires = null;
        if (ttl >= 0L) {
            expires = new Date(System.currentTimeMillis() + ttl * 1000L);
        }
        RemoteDataStorageEntry entry = new RemoteDataStorageEntry(data, expires);
        Map map = this.storage;
        synchronized (map) {
            do {
                if (++this.lastUsedKey != Long.MAX_VALUE) continue;
                this.lastUsedKey = 0L;
            } while (this.storage.get(key = new Long(this.lastUsedKey)) != null);
            this.storage.put(key, entry);
        }
        return key.toString();
    }

    public boolean isValidKey(String uid) {
        this.reap();
        if (uid == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        try {
            new Long(uid);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean hasData(String uid) {
        this.reap();
        if (uid == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long key = this.getKeyFromUID(uid);
        if (key != null) {
            return this.storage.get(key) != null;
        }
        log.error((Object)"Invalid UID");
        return false;
    }

    public Object getDataWithRemove(String uid) {
        this.reap();
        if (uid == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long key = this.getKeyFromUID(uid);
        if (key != null) {
            RemoteDataStorageEntry entry = (RemoteDataStorageEntry)this.storage.get(key);
            if (entry != null) {
                this.storage.remove(key);
                return entry.getData();
            }
            log.debug((Object)("RemoteDataStorage: key \"" + key + "\" not found in storage"));
            return null;
        }
        log.error((Object)"Invalid UID supplied");
        return null;
    }

    public Object getData(String uid) {
        this.reap();
        if (uid == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long key = this.getKeyFromUID(uid);
        if (key != null) {
            RemoteDataStorageEntry entry = (RemoteDataStorageEntry)this.storage.get(key);
            if (entry != null) {
                return entry.getData();
            }
            log.debug((Object)("RemoteDataStorage: key \"" + key + "\" not found in storage"));
            return null;
        }
        log.error((Object)"Invalid UID supplied");
        return null;
    }

    public void removeData(String uid) {
        this.reap();
        if (uid == null) {
            log.error((Object)"Invalid  argument");
            throw new NullPointerException();
        }
        Long key = this.getKeyFromUID(uid);
        if (key != null) {
            this.storage.remove(key);
        } else {
            log.error((Object)"Invalid uid supplied");
        }
    }

    protected Long getKeyFromUID(String uid) {
        Long key = null;
        try {
            key = new Long(uid);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Getting key from UID", (Throwable)e);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reap() {
        Map map = this.storage;
        synchronized (map) {
            Iterator entries = this.storage.entrySet().iterator();
            while (entries.hasNext()) {
                Date now;
                Map.Entry entry = entries.next();
                RemoteDataStorageEntry data = (RemoteDataStorageEntry)entry.getValue();
                if (data.getExpires() == null || (now = new Date(System.currentTimeMillis())).compareTo(data.getExpires()) <= 0) continue;
                entries.remove();
            }
        }
    }

    private class RemoteDataStorageEntry {
        private Object data = null;
        private Date expires = null;

        private RemoteDataStorageEntry() {
        }

        public RemoteDataStorageEntry(Object data, Date expires) {
            this.data = data;
            this.expires = expires;
        }

        public Object getData() {
            return this.data;
        }

        public Date getExpires() {
            return this.expires;
        }
    }

    private static class RemoteDataStorageHolder {
        private static RemoteDataStorage instance = new RemoteDataStorage();

        private RemoteDataStorageHolder() {
        }
    }
}

