/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.trust.cancel;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.ws.message.trust.cancel.RSTRCancelValidationResult;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedTokenCancelled;

public class RSTRCancelValidator {
    static final Logger log = Logger.getLogger(RSTRCancelValidator.class);

    public RSTRCancelValidationResult validate(OMElement element) {
        String newLine = System.getProperty("line.separator");
        RSTRCancelValidationResult result = new RSTRCancelValidationResult();
        RequestSecurityTokenResponse rstr = null;
        if (!SSOHelper.isRSTRElement(element)) {
            log.debug((Object)("RSTRIssueValidator.validate(): argument is not an RSTR element:[" + element.toString() + "]"));
            result.setCode(1);
            return result;
        }
        try {
            rstr = WSTrustObjectBuilder.buildRequestSecurityTokenResponse(element);
        }
        catch (SSOException e) {
            log.debug((Object)("RSTRIssueValidator.validate(): error deserialzing RSTR:" + newLine + "RST=[" + element.toString() + "]" + newLine + "exception message=[" + e.getMessage() + "]"));
            result.setCode(2);
            result.setMessage(e.getMessage());
            return result;
        }
        RequestedTokenCancelled requestedTokenCancelled = rstr.getRequestedTokenCancelled();
        if (requestedTokenCancelled == null) {
            result.setCode(10);
            return result;
        }
        result.setCode(0);
        return result;
    }
}

