/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSObject;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustVersion;

public abstract class BaseWSTrustObjectImpl
extends BaseWSObject
implements BaseWSInterface {
    static final Logger log = Logger.getLogger(BaseWSTrustObjectImpl.class);

    public boolean baseIsCompatibleElement(OMElement element, String expectedLocalName) throws SSOException {
        throw new SSOException("This method should never be called");
    }

    public WSTrust baseIsCompatibleElementTrust(OMElement element, String expectedLocalName) throws SSOException {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        String wstNSURI = null;
        if (element.getNamespace() == null) {
            if (element.getDefaultNamespace() == null) {
                return null;
            }
            wstNSURI = element.getDefaultNamespace().getNamespaceURI();
        } else {
            wstNSURI = element.getNamespace().getNamespaceURI();
        }
        if (element.getNamespace() == null) {
            return null;
        }
        if (StringHelper.isBlank(wstNSURI)) {
            return null;
        }
        if (!localName.equals(expectedLocalName)) {
            return null;
        }
        if (wstNSURI.equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            return new WSTrust(WSTrustVersion.V1);
        }
        if (!wstNSURI.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            return new WSTrust(WSTrustVersion.V2);
        }
        return null;
    }
}

