/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.config;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SOAPActionMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.SimpleStringMatcher;
import org.eclipse.alf.security.sso.common.http.configuration.matcher.URIMatcher;
import org.eclipse.alf.security.sso.common.token.saml.policy.SAML1Policy;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.URIResolverCache;

public class GatekeeperServiceConfig {
    private static final Logger log = Logger.getLogger(GatekeeperServiceConfig.class);
    public static final String SERVICE_NAME_DEFAULT = "default";
    public static final int SERVICE_TYPE_CALL_OUT = 0;
    public static final int SERVICE_TYPE_CALL_IN = 1;
    public static final int SERVICE_TYPE_CALL_INOUT = 2;
    public static final int SERVICE_PROTECTION_LEVEL_SOAP = 0;
    public static final int SERVICE_PROTECTION_LEVEL_BROWSER = 1;
    public static final int SERVICE_PROTECTION_LEVEL_ALL = 2;
    protected String name;
    protected int type;
    protected int protectionLevel;
    protected RPURI rpuri;
    protected CoreConfig coreConfig;
    protected PKIConfig pkiConfig;
    protected Hashtable browserTokenPolicies;
    protected Hashtable wsTokenPolicies;
    protected ArrayList browserURIMatchers;
    protected ArrayList dmzbrowserURIMatchers;
    protected ArrayList soapURIMatchers;
    protected ArrayList dmzsoapURIMatchers;
    protected ArrayList soapActionMatchers;
    protected ArrayList dmzSOAPActionMatchers;
    protected URIMatcher globalLogoutURIMatcher;
    protected URIMatcher localLogoutURIMatcher;

    public GatekeeperServiceConfig() {
        this.reset();
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public void reset() {
        this.name = null;
        this.rpuri = null;
        this.type = 1;
        this.protectionLevel = 2;
        this.coreConfig = null;
        this.pkiConfig = null;
        this.globalLogoutURIMatcher = null;
        this.localLogoutURIMatcher = null;
        this.browserURIMatchers = new ArrayList();
        this.dmzbrowserURIMatchers = new ArrayList();
        this.soapURIMatchers = new ArrayList();
        this.dmzsoapURIMatchers = new ArrayList();
        this.soapActionMatchers = new ArrayList();
        this.dmzSOAPActionMatchers = new ArrayList();
        this.browserTokenPolicies = new Hashtable();
        this.wsTokenPolicies = new Hashtable();
        this.browserTokenPolicies.put("*", new SAML1Policy());
        this.wsTokenPolicies.put("*", new SAML1Policy());
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    public void setProtectionLevel(int protectionLevel) {
        this.protectionLevel = protectionLevel;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    public void setCoreConfig(CoreConfig coreConfig) {
        this.coreConfig = coreConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RPURI getRpuri() {
        return this.rpuri;
    }

    public void setRpuri(RPURI rpuri) {
        this.rpuri = rpuri;
    }

    public boolean matchesGlobalLogoutURI(String uri, Map httpParamsMap) {
        if (this.globalLogoutURIMatcher == null) {
            return false;
        }
        return this.globalLogoutURIMatcher.matches(uri, httpParamsMap);
    }

    public boolean matchesLocalLogoutURI(String uri, Map httpParamsMap) {
        if (this.localLogoutURIMatcher == null) {
            return false;
        }
        return this.localLogoutURIMatcher.matches(uri, httpParamsMap);
    }

    public void setGlobalLogoutURI(URIMatcher globalLogoutURIMatcher) {
        this.globalLogoutURIMatcher = globalLogoutURIMatcher;
    }

    public void setLocalLogoutURI(URIMatcher localLogoutURIMatcher) {
        this.localLogoutURIMatcher = localLogoutURIMatcher;
    }

    public void addBrowserServiceURIMatcher(URIMatcher uri) {
        this.browserURIMatchers.add(uri);
    }

    public void addDMZBrowserServiceURIMatcher(URIMatcher uri) {
        this.dmzbrowserURIMatchers.add(uri);
    }

    public void addSOAPServiceURIMather(URIMatcher uri) {
        this.soapURIMatchers.add(uri);
    }

    public void addDMZSOAPServiceURIMatcher(URIMatcher uri) {
        this.dmzsoapURIMatchers.add(uri);
    }

    public void addSOAPActionMatcher(SOAPActionMatcher soapAction) {
        this.soapActionMatchers.add(soapAction);
    }

    public void addDMZSOAPActionMatcher(SOAPActionMatcher soapAction) {
        this.dmzSOAPActionMatchers.add(soapAction);
    }

    public boolean matchBrowserRequestURI(String uri, Map httpParamsMap, boolean addToURICache) {
        Boolean isBrowser;
        String urikey = URIMatcher.getMatchExpressionAsString((String)uri, (Map)httpParamsMap);
        URIResolverCache uricache = GatekeeperConfig.getInstance().getURIMatcherCache();
        if (uricache.hasURIEntry(urikey) && (isBrowser = uricache.getIsBrowser(urikey)) != null) {
            return isBrowser;
        }
        SortedMap browserMatchResults = this.genericURIMatch(this.browserURIMatchers, uri, httpParamsMap);
        SortedMap soapMatchResults = this.genericURIMatch(this.soapURIMatchers, uri, httpParamsMap);
        boolean matches = false;
        if (browserMatchResults.size() > 0) {
            if (soapMatchResults.size() == 0) {
                matches = true;
            } else {
                Long browserHighestMatchScore = (Long)browserMatchResults.lastKey();
                Long soapHighestMatchScore = (Long)soapMatchResults.lastKey();
                if (browserHighestMatchScore >= soapHighestMatchScore) {
                    matches = true;
                }
            }
        }
        if (addToURICache && matches) {
            uricache.setIsBrowser(uri, true);
        }
        return matches;
    }

    public boolean matchDMZBrowserRequestURI(String uri, Map httpParamsMap) {
        Boolean isDMZ;
        SortedMap matchResults = null;
        boolean matches = false;
        String urikey = URIMatcher.getMatchExpressionAsString((String)uri, (Map)httpParamsMap);
        URIResolverCache uricache = GatekeeperConfig.getInstance().getURIMatcherCache();
        if (uricache.hasURIEntry(urikey) && (isDMZ = uricache.getIsDMZ(urikey)) != null) {
            matches = isDMZ;
            return matches;
        }
        matchResults = this.genericURIMatch(this.dmzbrowserURIMatchers, uri, httpParamsMap);
        matches = matchResults.size() > 0;
        uricache.setIsDMZ(urikey, matches);
        return matches;
    }

    public boolean matchSOAPRequest(String uri, Map httpParamsMap, String soapAction, boolean addToURICache) {
        Boolean isBrowser;
        String urikey = URIMatcher.getMatchExpressionAsString((String)uri, (Map)httpParamsMap);
        URIResolverCache uricache = GatekeeperConfig.getInstance().getURIMatcherCache();
        if (uricache.hasURIEntry(urikey) && (isBrowser = uricache.getIsBrowser(urikey)) != null) {
            return isBrowser == false;
        }
        SortedMap browserMatchResults = this.genericURIMatch(this.browserURIMatchers, uri, httpParamsMap);
        SortedMap soapMatchResults = this.genericURIMatch(this.soapURIMatchers, uri, httpParamsMap);
        boolean matches = false;
        if (soapMatchResults.size() > 0) {
            if (browserMatchResults.size() == 0) {
                matches = true;
            } else {
                Long browserHighestMatchScore = (Long)browserMatchResults.lastKey();
                Long soapHighestMatchScore = (Long)soapMatchResults.lastKey();
                if (soapHighestMatchScore >= browserHighestMatchScore) {
                    matches = true;
                }
            }
        }
        if (matches) {
            uricache.setIsBrowser(uri, false);
        }
        if (soapAction != null && soapAction != null) {
            matches &= this.genericSimpleStringMatch(this.soapActionMatchers, soapAction);
        }
        return matches;
    }

    public boolean matchDMZSOAPRequest(String uri, Map httpParamsMap, String soapAction) {
        Boolean isDMZ;
        SortedMap matchResults = null;
        boolean matches = false;
        String urikey = URIMatcher.getMatchExpressionAsString((String)uri, (Map)httpParamsMap);
        URIResolverCache uricache = GatekeeperConfig.getInstance().getURIMatcherCache();
        if (uricache.hasURIEntry(urikey) && (isDMZ = uricache.getIsDMZ(urikey)) != null) {
            matches = isDMZ;
            if (soapAction != null) {
                matches &= this.genericSimpleStringMatch(this.dmzSOAPActionMatchers, soapAction);
            }
            return matches;
        }
        matchResults = this.genericURIMatch(this.dmzsoapURIMatchers, uri, httpParamsMap);
        matches = matchResults.size() > 0;
        uricache.setIsDMZ(urikey, matches);
        if (soapAction != null) {
            matches &= this.genericSimpleStringMatch(this.dmzSOAPActionMatchers, soapAction);
        }
        return matches;
    }

    private SortedMap genericURIMatch(List list, String uri, Map httpParamsMap) {
        Iterator it;
        TreeMap<Long, URIMatcher> result = new TreeMap<Long, URIMatcher>();
        if (list != null && (it = list.iterator()) != null) {
            while (it.hasNext()) {
                URIMatcher uriMatcher = (URIMatcher)it.next();
                if (!uriMatcher.matches(uri, httpParamsMap)) continue;
                Long matchScore = uriMatcher.getMatchScore();
                if (matchScore == null) {
                    matchScore = new Long(1L);
                    result.put(matchScore, uriMatcher);
                    break;
                }
                result.put(matchScore, uriMatcher);
            }
        }
        return result;
    }

    private boolean genericSimpleStringMatch(List list, String string) {
        Iterator it;
        if (list != null && (it = list.iterator()) != null) {
            while (it.hasNext()) {
                SimpleStringMatcher simpleStringMatcher = (SimpleStringMatcher)it.next();
                if (!simpleStringMatcher.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    public SAML1Policy getBrowserTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy browserTokenPolicy = (SAML1Policy)this.browserTokenPolicies.get(tokenType);
        if (browserTokenPolicy == null) {
            browserTokenPolicy = (SAML1Policy)this.browserTokenPolicies.get("*");
        }
        return browserTokenPolicy;
    }

    public void addBrowserTokenPolicy(String tokenType, SAML1Policy browserTokenPolicy) {
        this.browserTokenPolicies.put(tokenType, browserTokenPolicy);
    }

    public SAML1Policy getWsTokenPolicy(String tokenType) {
        if (tokenType == null) {
            return null;
        }
        SAML1Policy wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get(tokenType);
        if (wsTokenPolicy == null) {
            wsTokenPolicy = (SAML1Policy)this.wsTokenPolicies.get("*");
        }
        return wsTokenPolicy;
    }

    public void addWsTokenPolicy(String tokenType, SAML1Policy wsTokenPolicy) {
        this.wsTokenPolicies.put(tokenType, wsTokenPolicy);
    }

    public PKIConfig getPKIConfig() {
        return this.pkiConfig;
    }

    public void setPKIConfig(PKIConfig pkiConfig) {
        this.pkiConfig = pkiConfig;
    }
}

