/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.gatekeeper.handler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.http.cookie.CookieData;
import org.eclipse.alf.security.sso.common.http.cookie.CookieManager;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.config.GatekeeperServiceConfig;
import org.eclipse.alf.security.sso.server.gatekeeper.soap.secctx.SecCtxFedSvrRSTResponse;

public class HTTPRequestHandlerTokenExtractionHelper {
    private static final Logger log = Logger.getLogger(HTTPRequestHandlerTokenExtractionHelper.class);

    public static boolean extractIsTokenCanceledFromWSFedSignOutActionData(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig conf, WSFedData wsfData) throws ServletException, SSOException {
        String payloadString = null;
        OMElement payloadElement = null;
        log.debug((Object)"Begin signout action processing");
        if (!HTTPRequestHandlerTokenExtractionHelper.validateResponseContext(wsfData.getWctx())) {
            String errorMessage = "Signout action token extraction: Unsolicited or tampered fedration parameters: " + wsfData.toString();
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        payloadString = wsfData.getWresult();
        try {
            payloadElement = XMLHelper.toOM((String)payloadString);
        }
        catch (SSOException e) {
            String errorMessage = "Signin action token extraction: Error converting federation data to XML: \"" + payloadString + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signin action token extraction: payload is a full SOAP message");
            }
            try {
                payloadElement = HTTPRequestHandlerTokenExtractionHelper.extractPayloadFromSOAPElement(conf.getCoreConfig(), payloadString);
            }
            catch (SSOException e) {
                String errorMessage = "Signin action token extraction: Error extracting token from SOAP: " + payloadString;
                log.error((Object)errorMessage, (Throwable)e);
                throw new SSOException(errorMessage, (Throwable)e);
            }
        }
        if (SSOHelper.isRSTRElement((OMElement)payloadElement)) {
            RequestSecurityTokenResponse rstr = WSTrustObjectBuilder.buildRequestSecurityTokenResponse((OMElement)payloadElement);
            if (rstr == null) {
                String errorMessage = "Signin action token extraction: Error parsing RSTR: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            if (rstr.getRequestedTokenCancelled() != null) {
                return true;
            }
        }
        return false;
    }

    public static SSOToken extractSSOTokenFromWSFedSignInActionData(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig conf, WSFedData wsfData) throws ServletException, SSOException {
        String payloadString = null;
        OMElement payloadElement = null;
        SSOToken payloadToken = null;
        log.debug((Object)"Begin signin action token extraction");
        if (!HTTPRequestHandlerTokenExtractionHelper.validateResponseContext(wsfData.getWctx())) {
            String errorMessage = "Signin action token extraction: Unsolicited or tampered fedration parameters: " + wsfData.toString();
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        payloadString = wsfData.getWresult();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signin action token extraction: raw payload: " + payloadString));
        }
        try {
            payloadElement = XMLHelper.toOM((String)payloadString);
        }
        catch (SSOException e) {
            String errorMessage = "Signin action token extraction: Error converting federation data to XML: \"" + payloadString + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signin action token extraction: payload is a full SOAP message");
            }
            try {
                payloadElement = HTTPRequestHandlerTokenExtractionHelper.extractPayloadFromSOAPElement(conf.getCoreConfig(), payloadString);
            }
            catch (SSOException e) {
                String errorMessage = "Signin action token extraction: Error extracting token from SOAP: " + payloadString;
                log.error((Object)errorMessage, (Throwable)e);
                throw new SSOException(errorMessage, (Throwable)e);
            }
        }
        if (SSOHelper.isRSTRElement((OMElement)payloadElement)) {
            RequestSecurityTokenResponse rstr = WSTrustObjectBuilder.buildRequestSecurityTokenResponse((OMElement)payloadElement);
            if (rstr == null) {
                String errorMessage = "Signin action token extraction: Error parsing RSTR: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            RequestedSecurityToken requestedSecurityToken = rstr.getRequestedSecurityToken();
            if (requestedSecurityToken == null) {
                String errorMessage = "Signin action token extraction: Missing RSTR element: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            SecurityToken securityToken = requestedSecurityToken.getSecurityToken();
            if (securityToken == null) {
                String errorMessage = "Signin action token extraction: Missing security token in RSTR: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            String nativeTokenType = null;
            nativeTokenType = rstr.getTokenType() != null ? rstr.getTokenType().getTokenType() : securityToken.getType();
            if (StringHelper.isBlank((String)nativeTokenType)) {
                String errorMessage = "Signin action token extraction: Error determining token type: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signin action token extraction: Extracted WS-Security token type: " + nativeTokenType));
            }
            if (!SSOTokenFactory.isCompatibleNativeTokenType((String)nativeTokenType)) {
                String errorMessage = "Signin action token extraction: Unknown WS-Security token type: " + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            payloadElement = securityToken.toOM();
            if (payloadElement == null) {
                String errorMessage = "Signin action token extraction: Missing token in RSTR:" + payloadString;
                log.error((Object)errorMessage);
                throw new SSOException(errorMessage);
            }
            payloadString = payloadElement.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signin action token extraction: payload from ws-federation services response: " + payloadString));
        }
        try {
            payloadToken = SSOTokenFactory.createSSOToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            String errorMessage = "Signin action token extraction: Failed to create ALF SSO Security token: " + payloadString;
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        if (payloadToken == null) {
            String errorMessage = "Signin action token extraction: Failed to create ALF SSO Security token: " + payloadString;
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        return payloadToken;
    }

    public static SSOToken extractSSOTokenFromHTTPHeader(HttpServletRequest req, HttpServletResponse resp) throws SSOException {
        String payloadString = null;
        OMElement payloadElement = null;
        SSOToken payloadToken = null;
        payloadString = req.getHeader("ALFSSOAuthNToken");
        if (StringHelper.isBlank((String)payloadString)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SSO HTTP header ALFSSOAuthNToken not found or empty");
            }
            return null;
        }
        if (StringHelper.isBlank((String)(payloadString = SSOHelper.B64Decode((String)payloadString)))) {
            String errorMessage = "Error decoding base64 encoded token in HTTP header \"" + req.getHeader("ALFSSOAuthNToken") + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        try {
            payloadElement = XMLHelper.toOM((String)payloadString);
        }
        catch (SSOException e) {
            String errorMessage = "Error converting federation data to XML: \"" + payloadString + "\"";
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        try {
            payloadToken = SSOTokenFactory.createSSOToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            String errorMessage = "Failed to create ALF SSO Security token: " + payloadString;
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        if (payloadToken == null) {
            String errorMessage = "Failed to create ALF SSO Security token: " + payloadString;
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        return payloadToken;
    }

    public static SSOToken extractSSOTokenFromTokenCache(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig) throws SSOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking Token Cache for cookie matching request cookies");
        }
        SSOToken payloadToken = null;
        if (req.getCookies() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting payload from request cookies");
            }
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            String rawCookieData = null;
            try {
                rawCookieData = cookieManager.getBindCookiesToUserIP() ? cookieManager.extractRawCookiePayload(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), req.getRemoteAddr(), null) : cookieManager.extractRawCookiePayload(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), null, null);
            }
            catch (SSOException e) {
                String errorMessage = "Error processing cookies: " + e.getMessage();
                log.error((Object)errorMessage, (Throwable)e);
                throw new SSOException(errorMessage);
            }
            if (StringHelper.isNotBlank((String)rawCookieData)) {
                String checksum = DigestUtils.shaHex((String)rawCookieData);
                if (GatekeeperConfig.getInstance().getTokenCache().hasValidCacheEntry(checksum) && (payloadToken = GatekeeperConfig.getInstance().getTokenCache().getTokenByCookieChecksum(checksum)) != null && log.isDebugEnabled()) {
                    log.debug((Object)("Extracted SSO token from request cookies: " + payloadToken.toString()));
                }
            }
        }
        return payloadToken;
    }

    public static SSOToken extractSSOTokenFromCookies(HttpServletRequest req, HttpServletResponse resp, GatekeeperServiceConfig serviceConfig) throws SSOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking cookies for valid ALF SSO authentication tokens");
        }
        SSOToken payloadToken = null;
        if (req.getCookies() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extracting token from request cookies");
            }
            CookieManager cookieManager = serviceConfig.getCoreConfig().getCookieManager();
            String rawCookieData = null;
            CookieData cookieData = null;
            try {
                if (cookieManager.getBindCookiesToUserIP()) {
                    rawCookieData = cookieManager.extractRawCookiePayload(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), req.getRemoteAddr(), null);
                    cookieData = cookieManager.getCookie(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), req.getRemoteAddr(), rawCookieData, null);
                } else {
                    rawCookieData = cookieManager.extractRawCookiePayload(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), null, null);
                    cookieData = cookieManager.getCookie(req.getCookies(), serviceConfig.getRpuri().getType(), serviceConfig.getRpuri().getRealm(), null, rawCookieData, null);
                }
            }
            catch (SSOException e) {
                String errorMessage = "Error processing cookies: " + e.getMessage();
                log.error((Object)errorMessage, (Throwable)e);
                throw new SSOException(errorMessage);
            }
            if (cookieData != null && (payloadToken = cookieData.getToken()) != null && log.isDebugEnabled()) {
                log.debug((Object)("Extracted SSO token from request cookies: " + payloadToken.toString()));
            }
        }
        return payloadToken;
    }

    private static boolean validateResponseContext(String responseContext) {
        if (responseContext == null) {
            return false;
        }
        String responseContextKey = WSFedHelper.getKeyFromContext((String)responseContext);
        if (responseContextKey == null) {
            return false;
        }
        String responseUUID = (String)RemoteDataStorage.getInstance().getDataWithRemove(responseContextKey);
        if (responseUUID == null) {
            return false;
        }
        return WSFedHelper.isValidContextHash((String)responseContext, (String)responseUUID);
    }

    private static OMElement extractPayloadFromSOAPElement(CoreConfig coreConfig, String payloadString) throws SSOException {
        SOAPEnvelope payloadElement = null;
        try {
            payloadElement = SOAPHelper.buildSOAPElement((String)payloadString);
        }
        catch (SSOException e) {
            String errorMessage = "Signin action token extraction: Error trying to build a SOAP element from wresult: " + payloadString;
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        try {
            RSTDeserializer soapDeserializer = new RSTDeserializer(coreConfig.getAxis2ConfigurationContext());
            SecCtxFedSvrRSTResponse securityContext = new SecCtxFedSvrRSTResponse();
            soapDeserializer.setSecurityContext((SecurityContext)securityContext);
            payloadElement = soapDeserializer.receiveSOAPMessage(payloadElement.toString());
        }
        catch (AxisFault e) {
            String errorMessage = "Signin action token extraction: fault while extracting RST from SOAP message: " + payloadString;
            log.error((Object)errorMessage, (Throwable)e);
            throw new SSOException(errorMessage, (Throwable)e);
        }
        return payloadElement;
    }
}

