/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfigData;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigDataBuilder;

public class PKIConfigBuilder {
    private static final Logger log = Logger.getLogger(PKIConfigBuilder.class);
    public static final String INFLOW_CONFIG_LN = "InflowConfig";
    public static final String OUTFLOW_CONFIG_LN = "OutflowConfig";
    public static final String SIGNATURE_CONFIG_DATA_LN = "SignatureConfig";
    public static final String ENCRYPTION_CONFIG_DATA_LN = "EncryptionConfig";

    public PKIConfigData buildPKIConfigData(OMElement el, PKIConfigData base) {
        if (el == null) {
            return null;
        }
        PKIConfigDataBuilder pkiConfigDataBuilder = new PKIConfigDataBuilder();
        PKIConfigData pkiConfig = pkiConfigDataBuilder.build(el, base);
        if (pkiConfig != null) {
            return pkiConfig;
        }
        log.error((Object)("Failed to build <" + el.getLocalName() + "> element."));
        return base;
    }

    public PKIConfigData buildPKIConfigData(OMElement el, String localName, PKIConfigData base) {
        if (el == null) {
            return null;
        }
        OMElement pkiConfigEl = el.getFirstChildWithName(new QName(localName));
        if (pkiConfigEl != null) {
            PKIConfigDataBuilder pkiConfigDataBuilder = new PKIConfigDataBuilder();
            PKIConfigData pkiConfig = pkiConfigDataBuilder.build(pkiConfigEl, base);
            if (pkiConfig != null) {
                return pkiConfig;
            }
            log.error((Object)("Failed to build <" + localName + "> element."));
            return base;
        }
        log.warn((Object)("<" + localName + "> element is missing"));
        return base;
    }

    public PKIConfig build(OMElement element, PKIConfig base) {
        if (element == null) {
            return null;
        }
        PKIConfig pkiConfig = base != null ? (PKIConfig)base.clone() : new PKIConfig();
        OMElement inflowConfigEl = element.getFirstChildWithName(new QName(INFLOW_CONFIG_LN));
        if (inflowConfigEl != null) {
            pkiConfig.setInflowSignatureConfig(this.buildPKIConfigData(inflowConfigEl, SIGNATURE_CONFIG_DATA_LN, pkiConfig.getInflowSignatureConfig()));
            pkiConfig.setInflowEncryptionConfig(this.buildPKIConfigData(inflowConfigEl, ENCRYPTION_CONFIG_DATA_LN, pkiConfig.getInflowEncryptionConfig()));
        } else {
            log.warn((Object)"<InflowConfig> element is missing");
        }
        OMElement outflowConfigEl = element.getFirstChildWithName(new QName(OUTFLOW_CONFIG_LN));
        if (outflowConfigEl != null) {
            pkiConfig.setOutflowSignatureConfig(this.buildPKIConfigData(outflowConfigEl, SIGNATURE_CONFIG_DATA_LN, pkiConfig.getOutflowSignatureConfig()));
            pkiConfig.setOutflowEncryptionConfig(this.buildPKIConfigData(outflowConfigEl, ENCRYPTION_CONFIG_DATA_LN, pkiConfig.getOutflowEncryptionConfig()));
        } else {
            log.warn((Object)"<OutflowConfig> element is missing");
        }
        return pkiConfig;
    }
}

