/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.http.configuration.builder;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.http.configuration.PKIConfig;
import org.eclipse.alf.security.sso.common.http.configuration.builder.PKIConfigBuilder;

public class PKIConfigBuilderForPolicy
extends PKIConfigBuilder {
    private static final Logger log = Logger.getLogger(PKIConfigBuilderForPolicy.class);
    public static final String APPLICATION_SIGNATURE_CONFIG_LN = "ApplicationSignatureConfig";
    public static final String APPLICATION_ENCRYPTION_CONFIG_LN = "ApplicationEncryptionConfig";
    public static final String RELYING_PARTY_SIGNATURE_CONFIG_LN = "RelyingPartySignatureConfig";
    public static final String RELYING_PARTY_ENCRYPTION_CONFIG_LN = "RelyingPartyEncryptionConfig";

    public PKIConfig build(OMElement element, PKIConfig base, PKIConfig applicationPKIConfig, PKIConfig rpPKIConfig) {
        if (element == null) {
            return null;
        }
        PKIConfig pkiConfig = base != null ? (PKIConfig)base.clone() : new PKIConfig();
        OMElement inflowConfigEl = element.getFirstChildWithName(new QName("InflowConfig"));
        if (inflowConfigEl != null) {
            Iterator it = inflowConfigEl.getChildElements();
            while (it != null && it.hasNext()) {
                OMElement current = (OMElement)it.next();
                if (current.getLocalName().equals("SignatureConfig")) {
                    pkiConfig.setInflowSignatureConfig(this.buildPKIConfigData(current, pkiConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals(APPLICATION_SIGNATURE_CONFIG_LN)) {
                    pkiConfig.setInflowSignatureConfig(this.buildPKIConfigData(current, applicationPKIConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals(RELYING_PARTY_SIGNATURE_CONFIG_LN)) {
                    pkiConfig.setInflowSignatureConfig(this.buildPKIConfigData(current, rpPKIConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals("EncryptionConfig")) {
                    pkiConfig.setInflowEncryptionConfig(this.buildPKIConfigData(current, pkiConfig.getInflowEncryptionConfig()));
                    continue;
                }
                if (current.getLocalName().equals(APPLICATION_ENCRYPTION_CONFIG_LN)) {
                    pkiConfig.setInflowEncryptionConfig(this.buildPKIConfigData(current, applicationPKIConfig.getInflowEncryptionConfig()));
                    continue;
                }
                if (!current.getLocalName().equals(RELYING_PARTY_ENCRYPTION_CONFIG_LN)) continue;
                pkiConfig.setInflowEncryptionConfig(this.buildPKIConfigData(current, rpPKIConfig.getInflowEncryptionConfig()));
            }
        } else {
            log.warn((Object)"<InflowConfig> element is missing");
        }
        OMElement outflowConfigEl = element.getFirstChildWithName(new QName("OutflowConfig"));
        if (outflowConfigEl != null) {
            Iterator it = outflowConfigEl.getChildElements();
            while (it != null && it.hasNext()) {
                OMElement current = (OMElement)it.next();
                if (current.getLocalName().equals("SignatureConfig")) {
                    pkiConfig.setOutflowSignatureConfig(this.buildPKIConfigData(current, pkiConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals(APPLICATION_SIGNATURE_CONFIG_LN)) {
                    pkiConfig.setOutflowSignatureConfig(this.buildPKIConfigData(current, applicationPKIConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals(RELYING_PARTY_SIGNATURE_CONFIG_LN)) {
                    pkiConfig.setOutflowSignatureConfig(this.buildPKIConfigData(current, rpPKIConfig.getInflowSignatureConfig()));
                    continue;
                }
                if (current.getLocalName().equals("EncryptionConfig")) {
                    pkiConfig.setOutflowEncryptionConfig(this.buildPKIConfigData(current, pkiConfig.getInflowEncryptionConfig()));
                    continue;
                }
                if (current.getLocalName().equals(APPLICATION_ENCRYPTION_CONFIG_LN)) {
                    pkiConfig.setOutflowEncryptionConfig(this.buildPKIConfigData(current, applicationPKIConfig.getInflowEncryptionConfig()));
                    continue;
                }
                if (!current.getLocalName().equals(RELYING_PARTY_ENCRYPTION_CONFIG_LN)) continue;
                pkiConfig.setOutflowEncryptionConfig(this.buildPKIConfigData(current, rpPKIConfig.getInflowEncryptionConfig()));
            }
        } else {
            log.warn((Object)"<OutflowConfig> element is missing");
        }
        return pkiConfig;
    }
}

