/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidator;

public class SSOWSFedDataValidator
extends WSFedDataValidator {
    private static final Logger log = Logger.getLogger(SSOWSFedDataValidator.class);

    protected SSOWSFedDataValidator() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public ExtendedResult validateRequest(WSFedData wsfData) {
        ExtendedResult result = super.validateRequest(wsfData);
        if (!result.isSuccess()) {
            return result;
        }
        if (wsfData.isAttributeAction()) {
            result.setCode(2);
            result.setMessage("Attribute requests are not supported");
            return result;
        }
        if (wsfData.isPseudonymAction()) {
            result.setCode(2);
            result.setMessage("Pseudonym requests are not supported");
            return result;
        }
        result.setCode(0);
        return result;
    }
}

