/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.federation.passive;

import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.ExtendedResult;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData;
import org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedDataValidationResult;

public class WSFedDataValidator {
    private static final Logger log = Logger.getLogger(WSFedDataValidator.class);

    protected WSFedDataValidator() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public ExtendedResult validateRequest(WSFedData wsfData) {
        WSFedDataValidationResult result = new WSFedDataValidationResult();
        if (wsfData.getWa() == null) {
            result.setCode(3);
            result.setMessage("Action [wa] parameter is missing");
            return result;
        }
        if (!wsfData.validateWa()) {
            result.setCode(1);
            result.setMessage("Action [wa] parameter contains unsupported action: " + wsfData.getWa());
            return result;
        }
        if (!wsfData.validateWct()) {
            result.setCode(11);
            result.setMessage("Current time [wct] parameter is malformed: " + wsfData.getWct());
            return result;
        }
        if (wsfData.isSigninAction()) {
            boolean validRequest;
            if (wsfData.getWtrealm() == null && wsfData.getWreply() == null) {
                result.setCode(4);
                result.setMessage("On signin requests either [wtrealm] or [wreply] must be present");
                return result;
            }
            boolean bl = validRequest = StringHelper.isBlank(wsfData.getWreq()) || StringHelper.isBlank(wsfData.getWreqptr()) || StringHelper.isBlank(wsfData.getWtrealm());
            if (!validRequest) {
                result.setCode(5);
                result.setMessage("On signin requests either [wreq] or [wreqptr] must be present and containing valid request");
                return result;
            }
        } else if (!wsfData.isSignoutAction() && !wsfData.isSignoutCleanupAction()) {
            if (wsfData.isAttributeAction()) {
                if (wsfData.getWattr() == null) {
                    result.setCode(6);
                    result.setMessage("On attribute requests [wattr] must be present");
                    return result;
                }
            } else if (wsfData.isPseudonymAction() && wsfData.getWpseudo() == null) {
                result.setCode(7);
                result.setMessage("On pseudonym requests [pseudo] must be present");
                return result;
            }
        }
        result.setCode(0);
        return result;
    }

    public ExtendedResult validateResponse(WSFedData wsfData, boolean validateRequestFirst) {
        ExtendedResult reqValidationResult;
        WSFedDataValidationResult result = new WSFedDataValidationResult();
        if (validateRequestFirst && !(reqValidationResult = this.validateRequest(wsfData)).isSuccess()) {
            return reqValidationResult;
        }
        if (wsfData.isSigninAction()) {
            if (wsfData.getWresult() == null && wsfData.getWresultptr() == null) {
                result.setCode(8);
                result.setMessage("Responses must have either [wresult] or [wresultptr]");
                return result;
            }
        } else if (!wsfData.isSignoutAction() && !wsfData.isSignoutCleanupAction()) {
            if (wsfData.isAttributeAction()) {
                if (wsfData.getWresult() == null) {
                    result.setCode(9);
                    result.setMessage("Attribute responses must include [wattr] parameter");
                    return result;
                }
            } else if (wsfData.isPseudonymAction() && wsfData.getWresult() == null) {
                result.setCode(10);
                result.setMessage("Pseudonym responses must include [wresult] parameter");
                return result;
            }
        }
        result.setCode(0);
        return result;
    }
}

