/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressing;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.Action;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.impl.BaseWSAddressingObjectImpl;

public class ActionImpl
extends BaseWSAddressingObjectImpl
implements Action {
    private static final Logger log = Logger.getLogger(ActionImpl.class);
    protected String actionURI;

    public ActionImpl() {
        this.reset();
    }

    public ActionImpl(String action) {
        this.reset();
        this.actionURI = action;
    }

    public String getLocalName() {
        return "Action";
    }

    public void reset() {
        super.reset();
        this.actionURI = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof ActionImpl) {
            ActionImpl otherActionImpl = (ActionImpl)other;
            this.actionURI = otherActionImpl.actionURI;
        }
    }

    public void setActionURI(String actionURI) {
        this.actionURI = actionURI;
        this.setDirty();
    }

    public String getActionURI() {
        return this.actionURI;
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement actionEl = WSAddressing.createOMElement(parent, this.getLocalName());
        if (this.actionURI != null) {
            actionEl.setText(this.actionURI);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + actionEl.toString() + "]"));
        }
        this.addAnyAttributesToElement(actionEl);
        this.addAnyElementsToElementAsChildren(actionEl);
        return actionEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        ActionImpl action = new ActionImpl();
        action.actionURI = element.getText().trim();
        action.setParseSource(element);
        this.copyFrom(action);
        return this;
    }
}

