/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.policy.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.addressing.WSAddressingObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.policy.WSPolicy;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.AppliesTo;
import org.eclipse.alf.security.sso.common.ws.model.policy.element.impl.BaseWSPolicyObjectImpl;

public class AppliesToImpl
extends BaseWSPolicyObjectImpl
implements AppliesTo {
    private static final Logger log = Logger.getLogger(AppliesToImpl.class);
    protected List knownObjects;

    public AppliesToImpl() {
        this.reset();
    }

    public String getLocalName() {
        return "AppliesTo";
    }

    public void reset() {
        super.reset();
        this.knownObjects = new ArrayList();
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof AppliesToImpl) {
            AppliesToImpl otherAppliesToImpl = (AppliesToImpl)other;
            this.knownObjects = otherAppliesToImpl.knownObjects;
        }
    }

    public List getKnownObjectsList() {
        return this.knownObjects;
    }

    public void addChildObject(BaseWSInterface object) {
        this.knownObjects.add(object);
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement appliesToEl = WSPolicy.createOMElement(parent, this.getLocalName());
        Iterator it = null;
        if (this.knownObjects.size() > 0) {
            for (BaseWSInterface child : this.knownObjects) {
                child.toOM(appliesToEl);
            }
        }
        if (this._anyElement != null) {
            for (OMNode workNode : this._anyElement) {
                if (workNode.getType() != 1) continue;
                OMElement workEl = (OMElement)workNode;
                appliesToEl.addChild((OMNode)workEl);
            }
        }
        this.addAnyAttributesToElement(appliesToEl);
        this.addAnyElementsToElementAsChildren(appliesToEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + appliesToEl.toString() + "]"));
        }
        return appliesToEl;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        if (!this.isCompatibleElement(element)) {
            return null;
        }
        AppliesToImpl appliesTo = new AppliesToImpl();
        Iterator it = element.getChildElements();
        if (it != null) {
            while (it.hasNext()) {
                OMElement workEl = (OMElement)it.next();
                String localName = workEl.getLocalName();
                if ("Address".equals(localName)) {
                    appliesTo.knownObjects.add(WSAddressingObjectBuilder.buildAddress(workEl));
                    continue;
                }
                if ("EndpointReference".equals(localName)) {
                    appliesTo.knownObjects.add(WSAddressingObjectBuilder.buildEndpointReference(workEl));
                    continue;
                }
                appliesTo._anyElement.add(workEl.cloneOMElement());
            }
        }
        appliesTo.setParseSource(element);
        this.copyFrom(appliesTo);
        return this;
    }
}

