/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.BinarySecret;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;

public class BinarySecretImpl
extends BaseWSTrustObjectImpl
implements BinarySecret {
    private static final String ASYMMETRIC_KEY = "AsymmetricKey";
    private static final String SYMMETRIC_KEY = "SymmetricKey";
    private static final String NONCE = "Nonce";
    public static final String ATTR_TYPE = "Type";
    private static final Logger log = Logger.getLogger(BinarySecretImpl.class);
    protected WSTrust wst;
    protected String typeAttribute;
    protected String binarySecret;

    public BinarySecretImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public BinarySecretImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public BinarySecretImpl(WSTrust wst, String binarySecret) {
        this.reset();
        this.wst = wst;
        this.binarySecret = binarySecret;
    }

    public String getLocalName() {
        return "BinarySecret";
    }

    public void reset() {
        super.reset();
        this.typeAttribute = null;
        this.binarySecret = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof BinarySecretImpl) {
            BinarySecretImpl otherBinarySecretImpl = (BinarySecretImpl)other;
            this.wst = otherBinarySecretImpl.wst;
            this.typeAttribute = otherBinarySecretImpl.typeAttribute;
            this.binarySecret = otherBinarySecretImpl.binarySecret;
        }
    }

    public String getTypeAttribute() {
        if (this.typeAttribute == null) {
            return this.getDefaultKeyTypeURI();
        }
        return this.typeAttribute;
    }

    public void setTypeAttrribute(String type) {
        this.typeAttribute = type;
    }

    public String getAsymmetricKeyTypeURI() {
        return this.wst.getNamespace() + "/" + ASYMMETRIC_KEY;
    }

    public String getSymmetricKeyTypeURI() {
        return this.wst.getNamespace() + "/" + SYMMETRIC_KEY;
    }

    public String getNonceKeyTypeURI() {
        return this.wst.getNamespace() + "/" + NONCE;
    }

    public String getDefaultKeyTypeURI() {
        return this.getSymmetricKeyTypeURI();
    }

    public String getBinarySecret() {
        return this.binarySecret;
    }

    public void setBinarySecret(String binarySecret) {
        this.binarySecret = binarySecret;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        OMElement binarySecretEl = this.wst.createOMElement(parent, this.getLocalName());
        if (this.typeAttribute != null) {
            OMAttribute attr = OMAbstractFactory.getOMFactory().createOMAttribute(ATTR_TYPE, this.wst.getOMNamespace(), this.typeAttribute);
            binarySecretEl.addAttribute(attr);
        }
        if (this.binarySecret != null) {
            binarySecretEl.setText(this.binarySecret);
        }
        this.addAnyAttributesToElement(binarySecretEl);
        this.addAnyElementsToElementAsChildren(binarySecretEl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + this.getLocalName() + " object:[" + binarySecretEl.toString() + "]"));
        }
        return binarySecretEl;
    }

    public boolean isCompatibleElement(OMElement element) throws SSOException {
        return this.baseIsCompatibleElementTrust(element, this.getLocalName()) != null;
    }

    public BaseWSInterface fromOM(OMElement element) throws SSOException {
        WSTrust wst = this.baseIsCompatibleElementTrust(element, this.getLocalName());
        if (wst == null) {
            return null;
        }
        log.debug((Object)"Parsing <wst:BinarySecret>");
        BinarySecretImpl binarySecret = new BinarySecretImpl(wst);
        OMAttribute typeOMAttribute = element.getAttribute(new QName(wst.getNamespace(), ATTR_TYPE));
        if (typeOMAttribute != null) {
            binarySecret.setTypeAttrribute(typeOMAttribute.getAttributeValue());
        } else {
            binarySecret.setTypeAttrribute(this.getDefaultKeyTypeURI());
        }
        binarySecret.setBinarySecret(element.getText());
        binarySecret.setParseSource(element);
        this.copyFrom(binarySecret);
        return this;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

