/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.trust.element.impl;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.ws.model.BaseWSInterface;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.element.SecurityTokenReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrust;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedAttachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedUnattachedReference;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.BaseWSTrustObjectImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedAttachedReferenceImpl;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.impl.RequestedUnattachedReferenceImpl;

public abstract class RequestedReferenceCommonImpl
extends BaseWSTrustObjectImpl
implements RequestedAttachedReference,
RequestedUnattachedReference {
    private static final Logger log = Logger.getLogger(RequestedReferenceCommonImpl.class);
    protected WSTrust wst;
    protected SecurityTokenReference securityTokenReference;

    protected RequestedReferenceCommonImpl() {
        this.reset();
        this.wst = new WSTrust();
    }

    public RequestedReferenceCommonImpl(WSTrust wst) {
        this.reset();
        this.wst = wst;
    }

    public RequestedReferenceCommonImpl(WSTrust wst, SecurityTokenReference securityTokenReference) {
        this.reset();
        this.wst = wst;
        this.securityTokenReference = securityTokenReference;
    }

    public void reset() {
        super.reset();
        this.securityTokenReference = null;
    }

    public void copyFrom(BaseWSInterface other) {
        super.copyFrom(other);
        if (other instanceof RequestedReferenceCommonImpl) {
            RequestedReferenceCommonImpl otherRequestedReferenceCommonImpl = (RequestedReferenceCommonImpl)other;
            this.wst = otherRequestedReferenceCommonImpl.wst;
            this.securityTokenReference = otherRequestedReferenceCommonImpl.securityTokenReference;
        }
    }

    public abstract String getLocalName();

    public SecurityTokenReference getSecrutityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecrutityTokenReference(SecurityTokenReference securityTokenReference) {
        this.securityTokenReference = securityTokenReference;
        this.setDirty();
    }

    public OMElement toOM() {
        return this.toOM(null);
    }

    public OMElement toOM(OMElement parent) {
        if (!this.isParseSourceDirty()) {
            if (parent != null) {
                parent.addChild((OMNode)this.getParseSource());
            }
            return this.getParseSource();
        }
        return null;
    }

    protected static BaseWSInterface commonBuild(OMElement element, String expectedLocalName) throws SSOException {
        RequestedReferenceCommonImpl requestedReference = null;
        if (expectedLocalName.equals("RequestedAttachedReference")) {
            requestedReference = new RequestedAttachedReferenceImpl();
        } else if (expectedLocalName.equals("RequestedUnattachedReference")) {
            requestedReference = new RequestedUnattachedReferenceImpl();
        } else {
            log.error((Object)("Unknown element: " + expectedLocalName));
            throw new SSOException("Unknown element");
        }
        WSTrust wst = requestedReference.baseIsCompatibleElementTrust(element, expectedLocalName);
        if (wst == null) {
            return null;
        }
        requestedReference.wst = wst;
        if (element.getFirstElement() != null) {
            SecurityTokenReference securityTokenReference = WSSecExtObjectBuilder.buildSecurityTokenReference(element.getFirstElement());
            requestedReference.setSecrutityTokenReference(securityTokenReference);
        }
        requestedReference.setParseSource(element);
        return requestedReference;
    }

    public WSTrust getWSTrust() {
        return this.wst;
    }
}

