/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.StringHelper;

public class RPURI
implements Cloneable {
    private static final Logger log = Logger.getLogger(RPURI.class);
    public static final String RP_PREFIX = "uri:org:eclipse:alf:sso";
    public static final String RP_RELYING_PARTY = "relyingparty";
    public static final String RP_ANONYMOUS = "anonymous";
    public static final String RP_ANY = "any";
    public static final String RP_RELYING_PARTY_BASE_URI = "uri:org:eclipse:alf:sso:relyingparty";
    public static final String ANON_RP_URI = "uri:org:eclipse:alf:sso:relyingparty:anonymous:anonymous:anonymous";
    public static final String RP_TYPE_UNKNOWN = "anonymous";
    public static final String RP_TYPE_GATEKEEPER = "gatekeeper";
    public static final String RP_TYPE_PROXY_AGENT = "proxyagent";
    public static final int RP_TYPE_UNKNOWN_ID = 1;
    public static final int RP_TYPE_GATEKEEPER_ID = 2;
    public static final int RP_TYPE_PROXY_AUTHORITY_ID = 3;
    protected String rpBase;
    protected String rpType;
    protected String rpRealm;
    protected String rpInstance;

    public RPURI() {
        this.reset();
    }

    public RPURI(RPURI other) {
        this.reset();
        this.rpBase = other.rpBase;
        this.rpType = other.rpType;
        this.rpRealm = other.rpRealm;
        this.rpInstance = other.rpInstance;
    }

    public RPURI(String type, String realm, String instance) throws SSOException {
        this.reset();
        if (StringHelper.isNotBlank(type)) {
            if (type.indexOf(58) == -1) {
                this.rpType = type;
            } else {
                throw new SSOException("Type cannot contain ':'");
            }
        }
        if (StringHelper.isNotBlank(realm)) {
            if (realm.indexOf(58) == -1) {
                this.rpRealm = realm;
            } else {
                throw new SSOException("Realm cannot contain ':'");
            }
        }
        if (StringHelper.isNotBlank(instance)) {
            if (instance.indexOf(58) == -1) {
                this.rpInstance = instance;
            } else {
                throw new SSOException("Instance cannot contain ':'");
            }
        }
    }

    public RPURI(String rpuri) throws SSOException {
        this.reset();
        RPURI parsed = RPURI.fromString(rpuri);
        if (parsed == null) {
            String errorMessage = "Error parsing RPURI: \"" + rpuri + "\"";
            log.error((Object)errorMessage);
            throw new SSOException(errorMessage);
        }
        this.rpBase = parsed.rpBase;
        this.rpType = parsed.rpType;
        this.rpRealm = parsed.rpRealm;
        this.rpInstance = parsed.rpInstance;
    }

    public static RPURI createRPURI() {
        return new RPURI();
    }

    public static RPURI createRPURI(String type, String realm, String instance) {
        RPURI retVal;
        try {
            retVal = new RPURI(type, realm, instance);
        }
        catch (SSOException e) {
            return null;
        }
        return retVal;
    }

    public static RPURI createRPURI(String rpuri) {
        RPURI retVal;
        try {
            retVal = new RPURI(rpuri);
        }
        catch (SSOException e) {
            return null;
        }
        return retVal;
    }

    public void reset() {
        this.rpBase = RP_RELYING_PARTY_BASE_URI;
        this.rpType = "anonymous";
        this.rpRealm = "anonymous";
        this.rpInstance = "anonymous";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPURI fromString(String rpuri) {
        if (StringHelper.isBlank(rpuri)) {
            if (log.isDebugEnabled()) {
                log.error((Object)"Invalid argument: null rpURI");
            }
            return null;
        }
        if ((rpuri = rpuri.trim()).indexOf(RP_RELYING_PARTY_BASE_URI) != 0) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid relying party identifier URI: " + rpuri));
            }
            return null;
        }
        if (rpuri.length() <= RP_RELYING_PARTY_BASE_URI.length()) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid relying party identifier URI: " + rpuri));
            }
            return null;
        }
        if (rpuri.charAt(RP_RELYING_PARTY_BASE_URI.length()) != ':') {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid relying party identifier URI: " + rpuri));
            }
            return null;
        }
        String rpuriWorkString = rpuri.substring(0, RP_RELYING_PARTY_BASE_URI.length());
        if (!rpuriWorkString.equals(RP_RELYING_PARTY_BASE_URI)) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid RP URI:  " + rpuri));
            }
            return null;
        }
        rpuriWorkString = rpuri.substring(RP_RELYING_PARTY_BASE_URI.length() + 1);
        if (StringHelper.isBlank(rpuriWorkString)) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid RP URI:  " + rpuri));
            }
            return null;
        }
        StringTokenizer tok = new StringTokenizer(rpuriWorkString, ":");
        String currentToken = null;
        try {
            currentToken = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid RP URI:  " + rpuri));
            }
            return null;
        }
        String type = null;
        if (currentToken == null) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid relying party type token in the relying party URI: " + rpuri));
            }
            return null;
        }
        type = currentToken.trim();
        try {
            currentToken = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid RP URI:  " + rpuri));
            }
            return null;
        }
        String realm = null;
        if (currentToken == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid realm token in the relying party URI: " + rpuri));
            }
            return null;
        }
        realm = currentToken.trim();
        if (realm.length() == 0) {
            realm = "anonymous";
        }
        try {
            currentToken = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Invalid RP URI:  " + rpuri));
            }
            return null;
        }
        String instance = null;
        if (currentToken == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid relying party instance in the relying party URI: " + rpuri));
            }
            return null;
        }
        instance = currentToken.trim();
        if (instance.length() == 0) {
            instance = "anonymous";
        }
        try {
            currentToken = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            RPURI rPURI = RPURI.createRPURI(type, realm, instance);
            return rPURI;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid relying party instance in the relying party URI: " + rpuri));
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.rpBase);
        sb.append(":");
        sb.append(this.rpType);
        sb.append(":");
        sb.append(this.rpRealm);
        sb.append(":");
        sb.append(this.rpInstance);
        return sb.toString();
    }

    public static String getBase() {
        return RP_RELYING_PARTY_BASE_URI;
    }

    public String getType() {
        return this.rpType;
    }

    public void setType(String type) {
        this.rpType = type;
    }

    public String getInstance() {
        return this.rpInstance;
    }

    public void setInstance(String instance) {
        this.rpInstance = instance;
    }

    public String getRealm() {
        return this.rpRealm;
    }

    public void setRealm(String realm) {
        this.rpRealm = realm;
    }

    public Object clone() {
        return new RPURI(this);
    }
}

